/*
 * Decompiled with CFR 0.152.
 */
package com.zebra.criticalpermissionshelper;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import com.zebra.criticalpermissionshelper.CriticalPermissionsHelper;
import com.zebra.criticalpermissionshelper.IResultCallbacks;
import com.zebra.criticalpermissionshelper.ProfileManagerCommand;
import java.util.Base64;

class GrantContentPermission
extends AsyncTask<Object, Void, Boolean> {
    GrantContentPermission() {
    }

    protected Boolean doInBackground(Object ... objects) {
        Context context = (Context)objects[0];
        Uri uri = (Uri)objects[1];
        IResultCallbacks idiResultCallbacks = (IResultCallbacks)objects[2];
        GrantContentPermission.registerFolderForAccess(context, uri, idiResultCallbacks);
        return true;
    }

    private static void registerFolderForAccess(Context context, Uri folderOrFileURI, IResultCallbacks callbackInterface) {
        block6: {
            String profileName = "AccessMgr-1";
            String profileData = "";
            try {
                PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0x8000000);
                String path = context.getApplicationInfo().sourceDir;
                String strName = packageInfo.applicationInfo.loadLabel(context.getPackageManager()).toString();
                String strVendor = packageInfo.packageName;
                Signature sig = CriticalPermissionsHelper.apkCertificate;
                if (sig == null) {
                    Signature[] arrSignatures = null;
                    if (Build.VERSION.SDK_INT >= 28) {
                        arrSignatures = packageInfo.signingInfo.getApkContentsSigners();
                    }
                    if ((arrSignatures == null || arrSignatures.length == 0) && callbackInterface != null) {
                        callbackInterface.onError("Error : Package has no signing certificates... how's that possible ?", null);
                        return;
                    }
                    sig = arrSignatures[0];
                }
                byte[] rawCert = sig.toByteArray();
                String encoded = null;
                if (Build.VERSION.SDK_INT >= 26) {
                    encoded = Base64.getEncoder().encodeToString(rawCert);
                }
                profileData = "<?xml version=\"1.0\" encoding=\"utf-8\"?><characteristic type=\"Profile\"><parm name=\"ProfileName\" value=\"" + profileName + "\"/><characteristic type=\"AccessMgr\" version=\"9.2\"><parm name=\"OperationMode\" value=\"1\" /><parm name=\"ServiceAccessAction\" value=\"4\" /><parm name=\"ServiceIdentifier\" value=\"" + folderOrFileURI + "\" /><parm name=\"CallerPackageName\" value=\"" + context.getPackageName().toString() + "\" /><parm name=\"CallerSignature\" value=\"" + encoded + "\" /></characteristic></characteristic>";
                ProfileManagerCommand profileManagerCommand = new ProfileManagerCommand(context);
                profileManagerCommand.execute(profileData, profileName, callbackInterface);
            }
            catch (Exception e) {
                e.printStackTrace();
                if (callbackInterface == null) break block6;
                callbackInterface.onError("Error on profile: " + profileName + "\nError:" + e.getLocalizedMessage() + "\nProfileData:" + profileData, null);
            }
        }
    }

    private static void getURIValue(Cursor cursor, Uri uri, IResultCallbacks resultCallbacks) {
        while (cursor.moveToNext()) {
            if (cursor.getColumnCount() == 0) {
                String errorMsg = "Error: " + uri + " does not exist on this device";
                resultCallbacks.onDebugStatus(errorMsg);
                continue;
            }
            for (int i = 0; i < cursor.getColumnCount(); ++i) {
                try {
                    String data = cursor.getString(cursor.getColumnIndex(cursor.getColumnName(i)));
                    resultCallbacks.onSuccess(data, null);
                    cursor.close();
                    return;
                }
                catch (Exception e) {
                    resultCallbacks.onDebugStatus(e.getLocalizedMessage());
                    continue;
                }
            }
        }
        cursor.close();
        resultCallbacks.onError("Data not found in Uri:" + uri, null);
    }
}

