/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import java.io.File;
import java.util.ArrayList;
import me.nereo.multi_image_selector.MultiImageSelectorFragment;
import me.nereo.multi_image_selector.R;

public class MultiImageSelectorActivity
extends AppCompatActivity
implements MultiImageSelectorFragment.Callback {
    public static final int MODE_SINGLE = 0;
    public static final int MODE_MULTI = 1;
    public static final String EXTRA_SELECT_COUNT = "max_select_count";
    public static final String EXTRA_SELECT_MODE = "select_count_mode";
    public static final String EXTRA_SHOW_CAMERA = "show_camera";
    public static final String EXTRA_RESULT = "select_result";
    public static final String EXTRA_DEFAULT_SELECTED_LIST = "default_list";
    private static final int DEFAULT_IMAGE_SIZE = 9;
    private ArrayList<String> resultList = new ArrayList();
    private Button mSubmitButton;
    private int mDefaultCount = 9;

    protected void onCreate(Bundle savedInstanceState) {
        ActionBar actionBar;
        Toolbar toolbar;
        super.onCreate(savedInstanceState);
        this.setTheme(R.style.NO_ACTIONBAR);
        this.setContentView(R.layout.activity_default);
        if (Build.VERSION.SDK_INT >= 21) {
            this.getWindow().setStatusBarColor(-16777216);
        }
        if ((toolbar = (Toolbar)this.findViewById(R.id.toolbar)) != null) {
            this.setSupportActionBar(toolbar);
        }
        if ((actionBar = this.getSupportActionBar()) != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
        Intent intent = this.getIntent();
        this.mDefaultCount = intent.getIntExtra(EXTRA_SELECT_COUNT, 9);
        int mode = intent.getIntExtra(EXTRA_SELECT_MODE, 1);
        boolean isShow = intent.getBooleanExtra(EXTRA_SHOW_CAMERA, true);
        if (mode == 1 && intent.hasExtra(EXTRA_DEFAULT_SELECTED_LIST)) {
            this.resultList = intent.getStringArrayListExtra(EXTRA_DEFAULT_SELECTED_LIST);
        }
        this.mSubmitButton = (Button)this.findViewById(R.id.commit);
        if (mode == 1) {
            this.updateDoneText(this.resultList);
            this.mSubmitButton.setVisibility(0);
            this.mSubmitButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (MultiImageSelectorActivity.this.resultList != null && MultiImageSelectorActivity.this.resultList.size() > 0) {
                        Intent data = new Intent();
                        data.putStringArrayListExtra(MultiImageSelectorActivity.EXTRA_RESULT, MultiImageSelectorActivity.this.resultList);
                        MultiImageSelectorActivity.this.setResult(-1, data);
                    } else {
                        MultiImageSelectorActivity.this.setResult(0);
                    }
                    MultiImageSelectorActivity.this.finish();
                }
            });
        } else {
            this.mSubmitButton.setVisibility(8);
        }
        if (savedInstanceState == null) {
            Bundle bundle = new Bundle();
            bundle.putInt(EXTRA_SELECT_COUNT, this.mDefaultCount);
            bundle.putInt(EXTRA_SELECT_MODE, mode);
            bundle.putBoolean(EXTRA_SHOW_CAMERA, isShow);
            bundle.putStringArrayList(EXTRA_DEFAULT_SELECTED_LIST, this.resultList);
            this.getSupportFragmentManager().beginTransaction().add(R.id.image_grid, Fragment.instantiate((Context)this, (String)MultiImageSelectorFragment.class.getName(), (Bundle)bundle)).commit();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.setResult(0);
                this.finish();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void updateDoneText(ArrayList<String> resultList) {
        int size = 0;
        if (resultList == null || resultList.size() <= 0) {
            this.mSubmitButton.setText(R.string.action_done);
            this.mSubmitButton.setEnabled(false);
        } else {
            size = resultList.size();
            this.mSubmitButton.setEnabled(true);
        }
        this.mSubmitButton.setText((CharSequence)this.getString(R.string.action_button_string, new Object[]{this.getString(R.string.action_done), size, this.mDefaultCount}));
    }

    @Override
    public void onSingleImageSelected(String path) {
        Intent data = new Intent();
        this.resultList.add(path);
        data.putStringArrayListExtra(EXTRA_RESULT, this.resultList);
        this.setResult(-1, data);
        this.finish();
    }

    @Override
    public void onImageSelected(String path) {
        if (!this.resultList.contains(path)) {
            this.resultList.add(path);
        }
        this.updateDoneText(this.resultList);
    }

    @Override
    public void onImageUnselected(String path) {
        if (this.resultList.contains(path)) {
            this.resultList.remove(path);
        }
        this.updateDoneText(this.resultList);
    }

    @Override
    public void onCameraShot(File imageFile) {
        if (imageFile != null) {
            this.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)imageFile)));
            Intent data = new Intent();
            this.resultList.add(imageFile.getAbsolutePath());
            data.putStringArrayListExtra(EXTRA_RESULT, this.resultList);
            this.setResult(-1, data);
            this.finish();
        }
    }
}

