/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.widget.Toast;
import java.util.ArrayList;
import me.nereo.multi_image_selector.MultiImageSelectorActivity;
import me.nereo.multi_image_selector.R;

public class MultiImageSelector {
    public static final String EXTRA_RESULT = "select_result";
    private boolean mShowCamera = true;
    private int mMaxCount = 9;
    private int mMode = 1;
    private ArrayList<String> mOriginData;
    private static MultiImageSelector sSelector;
    private Context mContext;

    private MultiImageSelector(Context context) {
        this.mContext = context;
    }

    public static MultiImageSelector create(Context context) {
        if (sSelector == null) {
            sSelector = new MultiImageSelector(context);
        }
        return sSelector;
    }

    public MultiImageSelector showCamera(boolean show) {
        this.mShowCamera = show;
        return sSelector;
    }

    public MultiImageSelector count(int count) {
        this.mMaxCount = count;
        return sSelector;
    }

    public MultiImageSelector single() {
        this.mMode = 0;
        return sSelector;
    }

    public MultiImageSelector multi() {
        this.mMode = 1;
        return sSelector;
    }

    public MultiImageSelector origin(ArrayList<String> images) {
        this.mOriginData = images;
        return sSelector;
    }

    public void start(Activity activity, int requestCode) {
        if (this.hasPermission()) {
            activity.startActivityForResult(this.createIntent(), requestCode);
        } else {
            Toast.makeText((Context)this.mContext, (int)R.string.error_no_permission, (int)0).show();
        }
    }

    public void start(Fragment fragment, int requestCode) {
        if (this.hasPermission()) {
            fragment.startActivityForResult(this.createIntent(), requestCode);
        } else {
            Toast.makeText((Context)this.mContext, (int)R.string.error_no_permission, (int)0).show();
        }
    }

    private boolean hasPermission() {
        if (Build.VERSION.SDK_INT >= 16) {
            return ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
        }
        return true;
    }

    private Intent createIntent() {
        Intent intent = new Intent(this.mContext, MultiImageSelectorActivity.class);
        intent.putExtra("show_camera", this.mShowCamera);
        intent.putExtra("max_select_count", this.mMaxCount);
        if (this.mOriginData != null) {
            intent.putStringArrayListExtra("default_list", this.mOriginData);
        }
        intent.putExtra("select_count_mode", this.mMode);
        return intent;
    }
}

