/*
 * Decompiled with CFR 0.152.
 */
package com.loper7.date_time_picker;

import android.text.TextUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u0003\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lcom/loper7/date_time_picker/StringUtils;", "", "()V", "conversionTime", "", "time", "", "format", "getWeek", "date_time_picker_release"})
public final class StringUtils {
    public static final StringUtils INSTANCE;

    public final long conversionTime(@Nullable String time, @Nullable String format) {
        String format2 = format;
        if (TextUtils.isEmpty((CharSequence)format2)) {
            format2 = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format2);
        try {
            Date date = sdf.parse(time);
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"sdf.parse(time)");
            return date.getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    @NotNull
    public final String conversionTime(long time, @Nullable String format) {
        String format2 = format;
        if (TextUtils.isEmpty((CharSequence)format2)) {
            format2 = "yyyy-MM-dd HH:mm:ss";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format2);
        String string = sdf.format(new Date(time));
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sdf.format(Date(time))");
        return string;
    }

    @NotNull
    public final String getWeek(long time) {
        Calendar c;
        String Week = "";
        Calendar calendar = c = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"c");
        calendar.setTime(new Date(time));
        int wek = c.get(7);
        if (wek == 1) {
            Week = Week + "\u5468\u65e5";
        }
        if (wek == 2) {
            Week = Week + "\u5468\u4e00";
        }
        if (wek == 3) {
            Week = Week + "\u5468\u4e8c";
        }
        if (wek == 4) {
            Week = Week + "\u5468\u4e09";
        }
        if (wek == 5) {
            Week = Week + "\u5468\u56db";
        }
        if (wek == 6) {
            Week = Week + "\u5468\u4e94";
        }
        if (wek == 7) {
            Week = Week + "\u5468\u516d";
        }
        return Week;
    }

    private StringUtils() {
    }

    static {
        StringUtils stringUtils;
        INSTANCE = stringUtils = new StringUtils();
    }
}

