/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.slf4j.marker;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Marker;

public class LabelMarker
implements Marker {
    private static final String name = "LOKI4J_LABEL_MARKER";
    private final Supplier<Map<String, String>> labelsSupplier;
    private final AtomicReference<Map<String, String>> labelsValue = new AtomicReference<Object>(null);

    public LabelMarker(Supplier<Map<String, String>> labelsSupplier) {
        if (labelsSupplier == null) {
            throw new IllegalArgumentException("Labels can not be null");
        }
        this.labelsSupplier = labelsSupplier;
    }

    public String getName() {
        return name;
    }

    public Map<String, String> getLabels() {
        this.labelsValue.compareAndSet(null, this.labelsSupplier.get());
        return this.labelsValue.get();
    }

    public void add(Marker reference) {
        throw new UnsupportedOperationException("LabelMarker does not support adding references");
    }

    public boolean remove(Marker reference) {
        return false;
    }

    public boolean hasChildren() {
        return false;
    }

    public boolean hasReferences() {
        return false;
    }

    public Iterator<Marker> iterator() {
        return Collections.emptyIterator();
    }

    public boolean contains(Marker other) {
        return false;
    }

    public boolean contains(String name) {
        return false;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public static LabelMarker of(Supplier<Map<String, String>> labels) {
        return new LabelMarker(labels);
    }

    public static LabelMarker of(String key, Supplier<String> value) {
        return LabelMarker.of(() -> Collections.singletonMap(key, (String)value.get()));
    }
}

