/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.client.writer;

import com.github.loki4j.client.batch.LogRecord;
import com.github.loki4j.client.batch.LogRecordBatch;
import com.github.loki4j.client.batch.LogRecordStream;
import com.github.loki4j.client.util.ByteBufferFactory;
import com.github.loki4j.client.writer.Writer;
import com.github.loki4j.pkg.google.protobuf.Timestamp;
import com.github.loki4j.pkg.loki.protobuf.Logproto;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.xerial.snappy.Snappy;

public final class ProtobufWriter
implements Writer {
    private final ByteBuffer uncompressed;
    private final ByteBuffer compressed;
    private Logproto.PushRequest.Builder request;
    private Logproto.StreamAdapter.Builder stream;
    private int size = 0;

    public ProtobufWriter(int capacity, ByteBufferFactory bbFactory) {
        this.uncompressed = bbFactory.allocate(capacity);
        this.compressed = bbFactory.allocate(capacity + capacity / 2);
        this.request = Logproto.PushRequest.newBuilder();
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    public void serializeBatch(LogRecordBatch batch) {
        LogRecordStream currentStream = batch.get((int)0).stream;
        this.nextStream(currentStream.labels);
        for (int i = 0; i < batch.size(); ++i) {
            if (batch.get((int)i).stream != currentStream) {
                currentStream = batch.get((int)i).stream;
                this.nextStream(currentStream.labels);
            }
            this.nextEntry(batch.get(i));
        }
        try {
            this.endStreams();
        }
        catch (IOException e) {
            throw new RuntimeException("Protobuf encoding error", e);
        }
    }

    private void nextStream(String[] labelSet) {
        this.stream = this.request.addStreamsBuilder().setLabels(ProtobufWriter.label(labelSet));
    }

    static String label(String[] labels) {
        StringBuilder s = new StringBuilder();
        s.append('{');
        if (labels.length > 0) {
            for (int i = 0; i < labels.length; i += 2) {
                s.append(labels[i]);
                s.append('=');
                s.append('\"');
                s.append(labels[i + 1].replace("\"", "\\\""));
                s.append('\"');
                if (i >= labels.length - 2) continue;
                s.append(',');
            }
        }
        s.append('}');
        return s.toString();
    }

    private void nextEntry(LogRecord record) {
        this.stream.addEntries(Logproto.EntryAdapter.newBuilder().setTimestamp(Timestamp.newBuilder().setSeconds(record.timestampMs / 1000L).setNanos((int)(record.timestampMs % 1000L) * 1000000 + record.nanos)).setLine(record.message));
    }

    private void endStreams() throws IOException {
        CodedOutputStream writer = CodedOutputStream.newInstance((ByteBuffer)this.uncompressed);
        this.request.build().writeTo(writer);
        writer.flush();
        this.uncompressed.flip();
        if (this.uncompressed.hasArray()) {
            this.size = Snappy.compress((byte[])this.uncompressed.array(), (int)0, (int)this.uncompressed.limit(), (byte[])this.compressed.array(), (int)0);
            this.compressed.limit(this.size());
        } else {
            this.size = Snappy.compress((ByteBuffer)this.uncompressed, (ByteBuffer)this.compressed);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void toByteBuffer(ByteBuffer buffer) {
        buffer.put(this.compressed);
        buffer.flip();
        this.reset();
    }

    @Override
    public final byte[] toByteArray() {
        byte[] result = new byte[this.compressed.remaining()];
        this.compressed.get(result);
        this.reset();
        return result;
    }

    @Override
    public final void reset() {
        this.request = Logproto.PushRequest.newBuilder();
        this.stream = null;
        this.size = 0;
        this.uncompressed.clear();
        this.compressed.clear();
    }
}

