/*
 * Decompiled with CFR 0.152.
 */
package com.github.ln_12.library;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.util.Log;
import com.github.ln_12.library.ConnectivityStatus;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000f0\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/github/ln_12/library/ConnectivityStatus;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "isNetworkConnected", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "networkCallback", "com/github/ln_12/library/ConnectivityStatus$networkCallback$1", "Lcom/github/ln_12/library/ConnectivityStatus$networkCallback$1;", "getStatus", "", "success", "Lkotlin/Function1;", "start", "stop", "multiplatform-connectivity-status_release"})
public final class ConnectivityStatus {
    @NotNull
    private final Context context;
    @NotNull
    private final MutableStateFlow<Boolean> isNetworkConnected;
    @Nullable
    private final ConnectivityManager connectivityManager;
    @NotNull
    private final networkCallback.1 networkCallback;

    public ConnectivityStatus(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.isNetworkConnected = StateFlowKt.MutableStateFlow((Object)false);
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ ConnectivityStatus this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Log.d((String)"Connectivity status", (String)"Network available");
                this.this$0.isNetworkConnected().setValue((Object)true);
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Log.d((String)"Connectivity status", (String)"Network lost");
                this.this$0.isNetworkConnected().setValue((Object)false);
            }

            public void onCapabilitiesChanged(@NotNull Network network, @NotNull NetworkCapabilities networkCapabilities) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
                super.onCapabilitiesChanged(network, networkCapabilities);
                boolean isConnected = networkCapabilities.hasCapability(12) && networkCapabilities.hasCapability(13) && (Build.VERSION.SDK_INT >= 23 ? networkCapabilities.hasCapability(16) : true);
                Log.d((String)"Connectivity status", (String)("Network status: " + (isConnected ? "Connected" : "Disconnected")));
                this.this$0.isNetworkConnected().setValue((Object)isConnected);
            }
        };
    }

    @NotNull
    public final MutableStateFlow<Boolean> isNetworkConnected() {
        return this.isNetworkConnected;
    }

    public final void start() {
        try {
            Object object = this.context.getSystemService("connectivity");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            if (Build.VERSION.SDK_INT >= 24) {
                connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
                Network currentNetwork = connectivityManager.getActiveNetwork();
                if (currentNetwork == null) {
                    this.isNetworkConnected.setValue((Object)false);
                    Log.d((String)"Connectivity status", (String)"Disconnected");
                }
            } else {
                NetworkRequest.Builder builder;
                NetworkRequest.Builder $this$start_u24lambda_u2d0 = builder = new NetworkRequest.Builder();
                boolean bl = false;
                $this$start_u24lambda_u2d0.addCapability(12);
                $this$start_u24lambda_u2d0.addCapability(13);
                if (Build.VERSION.SDK_INT >= 23) {
                    $this$start_u24lambda_u2d0.addCapability(16);
                }
                NetworkRequest networkRequest = builder.build();
                connectivityManager.registerNetworkCallback(networkRequest, (ConnectivityManager.NetworkCallback)this.networkCallback);
                NetworkInfo currentNetwork = connectivityManager.getActiveNetworkInfo();
                if (currentNetwork == null || currentNetwork.getType() != 9 && currentNetwork.getType() != 1 && currentNetwork.getType() != 0) {
                    this.isNetworkConnected.setValue((Object)false);
                    Log.d((String)"Connectivity status", (String)"Disconnected");
                }
            }
            Log.d((String)"Connectivity status", (String)"Started");
        }
        catch (Exception e) {
            Log.d((String)"Connectivity status", (String)("Failed to start: " + e.getMessage()));
            e.printStackTrace();
            this.isNetworkConnected.setValue((Object)false);
        }
    }

    public final void stop() {
        ConnectivityManager connectivityManager = this.connectivityManager;
        if (connectivityManager != null) {
            connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
        }
        Log.d((String)"Connectivity status", (String)"Stopped");
    }

    public final void getStatus(@NotNull Function1<? super Boolean, Unit> success) {
        Intrinsics.checkNotNullParameter(success, (String)"success");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, success, null){
            int label;
            final /* synthetic */ ConnectivityStatus this$0;
            final /* synthetic */ Function1<Boolean, Unit> $success;
            {
                this.this$0 = $receiver;
                this.$success = $success;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.isNetworkConnected().collect(new FlowCollector(this.$success){
                            final /* synthetic */ Function1<Boolean, Unit> $success;
                            {
                                this.$success = $success;
                            }

                            @Nullable
                            public final Object emit(boolean status, @NotNull Continuation<? super Unit> $completion) {
                                Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$success, status, null){
                                    int label;
                                    final /* synthetic */ Function1<Boolean, Unit> $success;
                                    final /* synthetic */ boolean $status;
                                    {
                                        this.$success = $success;
                                        this.$status = $status;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.$success.invoke((Object)Boxing.boxBoolean((boolean)this.$status));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), $completion);
                                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                    return object;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }
}

