/*
 * Decompiled with CFR 0.152.
 */
package com.github.ln-12.library;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.util.Log;
import com.github.ln-12.library.ConnectivityStatus;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002*\u0001\f\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\nR\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/github/ln-12/library/ConnectivityStatus;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "isNetworkConnected", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "networkCallback", "com/github/ln-12/library/ConnectivityStatus$networkCallback$1", "Lcom/github/ln-12/library/ConnectivityStatus$networkCallback$1;", "start", "", "stop", "multiplatform-connectivity-status_release"})
public final class ConnectivityStatus {
    @NotNull
    private final MutableStateFlow<Boolean> isNetworkConnected;
    private final ConnectivityManager connectivityManager;
    private final networkCallback.1 networkCallback;
    private final Context context;

    @NotNull
    public final MutableStateFlow<Boolean> isNetworkConnected() {
        return this.isNetworkConnected;
    }

    public final void start() {
        try {
            Object object = this.context.getSystemService("connectivity");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
            }
            ConnectivityManager connectivityManager = (ConnectivityManager)object;
            connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
        }
        catch (Exception e) {
            Log.d((String)"Connectivity status", (String)("Failed to start: " + String.valueOf(e.getMessage())));
            e.printStackTrace();
            this.isNetworkConnected.setValue((Object)false);
        }
    }

    public final void stop() {
        block0: {
            ConnectivityManager connectivityManager = this.connectivityManager;
            if (connectivityManager == null) break block0;
            connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
        }
    }

    public ConnectivityStatus(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.isNetworkConnected = StateFlowKt.MutableStateFlow((Object)false);
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ ConnectivityStatus this$0;

            public void onAvailable(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Log.d((String)"Connectivity status", (String)"Connected");
                this.this$0.isNetworkConnected().setValue((Object)true);
            }

            public void onLost(@NotNull Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Log.d((String)"Connectivity status", (String)"Disconnected");
                this.this$0.isNetworkConnected().setValue((Object)false);
            }
            {
                this.this$0 = this$0;
            }
        };
    }
}

