/*
 * Decompiled with CFR 0.152.
 */
package com.darkprograms.speech.synthesiser;

import com.darkprograms.speech.translator.GoogleTranslate;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Synthesiser {
    private static final String GOOGLE_SYNTHESISER_URL = "http://translate.google.com/translate_tts";
    private String languageCode;
    public static final String LANG_AU_ENGLISH = "en-AU";
    public static final String LANG_US_ENGLISH = "en-US";
    public static final String LANG_UK_ENGLISH = "en-GB";
    public static final String LANG_ES_SPANISH = "es";
    public static final String LANG_FR_FRENCH = "fr";
    public static final String LANG_DE_GERMAN = "de";
    public static final String LANG_PT_PORTUGUESE = "pt-pt";
    public static final String LANG_PT_BRAZILIAN = "pt-br";

    public Synthesiser() {
        this.languageCode = "auto";
    }

    public Synthesiser(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public void setLanguage(String languageCode) {
        this.languageCode = languageCode;
    }

    public InputStream getMP3Data(String synthText) throws IOException {
        String languageCode = this.languageCode;
        if ((languageCode == null || languageCode.equals("") || languageCode.equalsIgnoreCase("auto")) && (languageCode = this.detectLanguage(synthText)) == null) {
            languageCode = "en-us";
        }
        if (synthText.length() > 100) {
            List<String> fragments = this.parseString(synthText);
            String tmp = this.getLanguage();
            this.setLanguage(languageCode);
            InputStream out = this.getMP3Data(fragments);
            this.setLanguage(tmp);
            return out;
        }
        String encoded = URLEncoder.encode(synthText, "UTF-8");
        StringBuilder sb = new StringBuilder();
        sb.append(GOOGLE_SYNTHESISER_URL);
        sb.append("?tl=");
        sb.append(languageCode);
        sb.append("&q=");
        sb.append(encoded);
        sb.append("&ie=UTF-8&total=1&idx=0");
        sb.append("&textlen=");
        sb.append(synthText.length());
        sb.append("&client=tw-ob");
        URL url = new URL(sb.toString());
        URLConnection urlConn = url.openConnection();
        urlConn.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:2.0) Gecko/20100101 Firefox/4.0");
        return urlConn.getInputStream();
    }

    public InputStream getMP3Data(List<String> synthText) throws IOException {
        ExecutorService pool = Executors.newFixedThreadPool(1000);
        LinkedHashSet<Future<InputStream>> set = new LinkedHashSet<Future<InputStream>>(synthText.size());
        for (String part : synthText) {
            MP3DataFetcher mP3DataFetcher = new MP3DataFetcher(part);
            Future<InputStream> future = pool.submit(mP3DataFetcher);
            set.add(future);
        }
        ArrayList inputStreams = new ArrayList(set.size());
        for (Future future : set) {
            try {
                inputStreams.add(future.get());
            }
            catch (ExecutionException e) {
                Throwable ex = e.getCause();
                if (!(ex instanceof IOException)) continue;
                throw (IOException)ex;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return new SequenceInputStream(Collections.enumeration(inputStreams));
    }

    private List<String> parseString(String input) {
        return this.parseString(input, new ArrayList<String>());
    }

    private List<String> parseString(String input, List<String> fragments) {
        if (input.length() <= 100) {
            fragments.add(input);
            return fragments;
        }
        int lastWord = this.findLastWord(input);
        if (lastWord <= 0) {
            fragments.add(input.substring(0, 100));
            return this.parseString(input.substring(100), fragments);
        }
        fragments.add(input.substring(0, lastWord));
        return this.parseString(input.substring(lastWord), fragments);
    }

    private int findLastWord(String input) {
        if (input.length() < 100) {
            return input.length();
        }
        int space = -1;
        for (int i = 99; i > 0; --i) {
            char tmp = input.charAt(i);
            if (this.isEndingPunctuation(tmp)) {
                return i + 1;
            }
            if (space != -1 || tmp != ' ') continue;
            space = i;
        }
        if (space > 0) {
            return space;
        }
        return -1;
    }

    private boolean isEndingPunctuation(char input) {
        return input == '.' || input == '!' || input == '?' || input == ';' || input == ':' || input == '|';
    }

    public String detectLanguage(String text) throws IOException {
        return GoogleTranslate.detectLanguage(text);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MP3DataFetcher
    implements Callable<InputStream> {
        private String synthText;

        public MP3DataFetcher(String synthText) {
            this.synthText = synthText;
        }

        @Override
        public InputStream call() throws IOException {
            return Synthesiser.this.getMP3Data(this.synthText);
        }
    }
}

