/*
 * Decompiled with CFR 0.152.
 */
package com.darkprograms.speech.recognizer;

import com.darkprograms.speech.recognizer.GSpeechResponseListener;
import com.darkprograms.speech.recognizer.GoogleResponse;
import com.darkprograms.speech.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.ws.http.HTTPException;

public class RecognizerChunked {
    private static final String GOOGLE_SPEECH_URL_V2 = "https://www.google.com/speech-api/v2/recognize";
    private final String API_KEY;
    private String language;
    private List<GSpeechResponseListener> responseListeners = new ArrayList<GSpeechResponseListener>();

    public RecognizerChunked(String API_KEY) {
        this.API_KEY = API_KEY;
        this.language = "auto";
    }

    public RecognizerChunked(String API_KEY, String language) {
        this(API_KEY);
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void getRecognizedDataForFlac(File infile, int sampleRate) throws IOException {
        byte[] data = this.mapFileIn(infile);
        this.getRecognizedDataForFlac(data, sampleRate);
    }

    public void getRecognizedDataForFlac(String inFile, int sampleRate) throws IOException {
        this.getRecognizedDataForFlac(new File(inFile), sampleRate);
    }

    public void getRecognizedDataForFlac(byte[] data, int sampleRate) {
        StringBuilder sb = new StringBuilder(GOOGLE_SPEECH_URL_V2);
        sb.append("?output=json");
        sb.append("&client=chromium");
        sb.append("&lang=" + this.language);
        sb.append("&key=" + this.API_KEY);
        String url = sb.toString();
        this.openHttpsPostConnection(url, data, sampleRate);
    }

    private void openHttpsPostConnection(final String urlStr, final byte[] data, final int sampleRate) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                HttpURLConnection httpConn = null;
                ByteBuffer buff = ByteBuffer.wrap(data);
                byte[] destdata = new byte[2048];
                int resCode = -1;
                OutputStream out = null;
                try {
                    String line;
                    URL url = new URL(urlStr);
                    URLConnection urlConn = url.openConnection();
                    if (!(urlConn instanceof HttpsURLConnection)) {
                        throw new IOException("URL must be HTTPS");
                    }
                    httpConn = (HttpsURLConnection)urlConn;
                    httpConn.setAllowUserInteraction(false);
                    httpConn.setInstanceFollowRedirects(true);
                    httpConn.setRequestMethod("POST");
                    httpConn.setDoOutput(true);
                    httpConn.setChunkedStreamingMode(0);
                    httpConn.setRequestProperty("Content-Type", "audio/x-flac; rate=" + sampleRate);
                    out = httpConn.getOutputStream();
                    while (buff.remaining() >= destdata.length) {
                        buff.get(destdata);
                        out.write(destdata);
                    }
                    byte[] lastr = new byte[buff.remaining()];
                    buff.get(lastr, 0, lastr.length);
                    out.write(lastr);
                    out.close();
                    resCode = httpConn.getResponseCode();
                    if (resCode >= 401) {
                        throw new HTTPException(401);
                    }
                    BufferedReader br = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        if (line.length() <= 19 || resCode <= 100 || resCode >= 401) continue;
                        GoogleResponse gr = new GoogleResponse();
                        RecognizerChunked.this.parseResponse(line, gr);
                        RecognizerChunked.this.fireResponseEvent(gr);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    httpConn.disconnect();
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] mapFileIn(File infile) throws IOException {
        FileInputStream fis = new FileInputStream(infile);
        try {
            FileChannel fc = fis.getChannel();
            int sz = (int)fc.size();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            byte[] data2 = new byte[bb.remaining()];
            bb.get(data2);
            byte[] byArray = data2;
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    private void parseResponse(String rawResponse, GoogleResponse gr) {
        if (rawResponse == null || !rawResponse.contains("\"result\"")) {
            return;
        }
        if (rawResponse.contains("\"confidence\":")) {
            String confidence = StringUtil.substringBetween(rawResponse, "\"confidence\":", "}");
            gr.setConfidence(confidence);
        } else {
            gr.setConfidence(String.valueOf(1.0));
        }
        String array = StringUtil.trimString(rawResponse, "[", "]");
        if (array.contains("[")) {
            array = StringUtil.trimString(array, "[", "]");
        }
        String[] parts = array.split(",");
        gr.setResponse(this.parseTranscript(parts[0]));
        for (int i = 1; i < parts.length; ++i) {
            gr.getOtherPossibleResponses().add(this.parseTranscript(parts[i]));
        }
    }

    private String parseTranscript(String s) {
        String tmp = s.substring(s.indexOf(":") + 1);
        if (s.endsWith("}")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        tmp = StringUtil.stripQuotes(tmp);
        return tmp;
    }

    public synchronized void addResponseListener(GSpeechResponseListener rl) {
        this.responseListeners.add(rl);
    }

    public synchronized void removeResponseListener(GSpeechResponseListener rl) {
        this.responseListeners.remove(rl);
    }

    private synchronized void fireResponseEvent(GoogleResponse gr) {
        for (GSpeechResponseListener gl : this.responseListeners) {
            gl.onResponse(gr);
        }
    }
}

