/*
 * Decompiled with CFR 0.152.
 */
package com.darkprograms.speech.recognizer;

import com.darkprograms.speech.recognizer.FlacEncoder;
import com.darkprograms.speech.recognizer.GoogleResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

@Deprecated
public class Recognizer {
    private static final String GOOGLE_RECOGNIZER_URL = "http://www.google.com/speech-api/v2/recognize?client=chromium&output=json";
    private boolean profanityFilter = true;
    private String language = null;
    private String apikey = null;

    @Deprecated
    public Recognizer(String language, String apikey) {
        this.language = language;
        this.apikey = apikey;
    }

    public Recognizer(Languages language, String apikey) {
        this.language = language.languageCode;
        this.apikey = apikey;
    }

    public Recognizer(boolean profanityFilter, String apikey) {
        this.profanityFilter = profanityFilter;
        this.apikey = apikey;
    }

    @Deprecated
    public Recognizer(String language, boolean profanityFilter, String apikey) {
        this.language = language;
        this.profanityFilter = profanityFilter;
        this.apikey = apikey;
    }

    public Recognizer(Languages language, boolean profanityFilter, String apikey) {
        this.language = language.languageCode;
        this.profanityFilter = profanityFilter;
        this.apikey = apikey;
    }

    public void setLanguage(Languages language) {
        this.language = language.languageCode;
    }

    @Deprecated
    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean getProfanityFilter() {
        return this.profanityFilter;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getApiKey() {
        return this.apikey;
    }

    public void setApiKey(String apikey) {
        this.apikey = apikey;
    }

    public GoogleResponse getRecognizedDataForWave(File waveFile, int maxResults) throws IOException {
        FlacEncoder flacEncoder = new FlacEncoder();
        File flacFile = new File(waveFile + ".flac");
        flacEncoder.convertWaveToFlac(waveFile, flacFile);
        GoogleResponse googleResponse = this.getRecognizedDataForFlac(flacFile, maxResults, 8000);
        flacFile.delete();
        return googleResponse;
    }

    public GoogleResponse getRecognizedDataForWave(String waveFile, int maxResults) throws IOException {
        return this.getRecognizedDataForWave(new File(waveFile), maxResults);
    }

    public GoogleResponse getRecognizedDataForFlac(File flacFile, int maxResults) throws IOException {
        return this.getRecognizedDataForFlac(flacFile, maxResults, 8000);
    }

    public GoogleResponse getRecognizedDataForFlac(File flacFile, int maxResults, int sampleRate) throws IOException {
        String[] response = this.rawRequest(flacFile, maxResults, sampleRate);
        GoogleResponse googleResponse = new GoogleResponse();
        this.parseResponse(response, googleResponse);
        return googleResponse;
    }

    public GoogleResponse getRecognizedDataForFlac(String flacFile, int maxResults, int sampleRate) throws IOException {
        return this.getRecognizedDataForFlac(new File(flacFile), maxResults, sampleRate);
    }

    public GoogleResponse getRecognizedDataForFlac(String flacFile, int maxResults) throws IOException {
        return this.getRecognizedDataForFlac(new File(flacFile), maxResults);
    }

    public GoogleResponse getRecognizedDataForWave(File waveFile) throws IOException {
        return this.getRecognizedDataForWave(waveFile, 1);
    }

    public GoogleResponse getRecognizedDataForWave(String waveFile) throws IOException {
        return this.getRecognizedDataForWave(waveFile, 1);
    }

    public GoogleResponse getRecognizedDataForFlac(File flacFile) throws IOException {
        return this.getRecognizedDataForFlac(flacFile, 1);
    }

    public GoogleResponse getRecognizedDataForFlac(String flacFile) throws IOException {
        return this.getRecognizedDataForFlac(flacFile, 1);
    }

    private void parseResponse(String[] rawResponse, GoogleResponse googleResponse) {
        for (String s : rawResponse) {
            JSONObject jsonResponse = new JSONObject(s);
            JSONArray jsonResultArray = jsonResponse.getJSONArray("result");
            for (int i = 0; i < jsonResultArray.length(); ++i) {
                JSONObject jsonAlternativeObject = jsonResultArray.getJSONObject(i);
                JSONArray jsonAlternativeArray = jsonAlternativeObject.getJSONArray("alternative");
                double prevConfidence = 0.0;
                for (int j = 0; j < jsonAlternativeArray.length(); ++j) {
                    JSONObject jsonTranscriptObject = jsonAlternativeArray.getJSONObject(j);
                    String transcript = jsonTranscriptObject.optString("transcript", "");
                    double confidence = jsonTranscriptObject.optDouble("confidence", 0.0);
                    if (confidence > prevConfidence) {
                        googleResponse.setResponse(transcript);
                        googleResponse.setConfidence(String.valueOf(confidence));
                        prevConfidence = confidence;
                        continue;
                    }
                    googleResponse.getOtherPossibleResponses().add(transcript);
                }
            }
        }
    }

    private String[] rawRequest(File inputFile, int maxResults, int sampleRate) throws IOException {
        StringBuilder sb = new StringBuilder(GOOGLE_RECOGNIZER_URL);
        if (this.language != null) {
            sb.append("&lang=");
            sb.append(this.language);
        } else {
            sb.append("&lang=auto");
        }
        if (this.apikey != null) {
            sb.append("&key=");
            sb.append(this.apikey);
        }
        if (!this.profanityFilter) {
            sb.append("&pfilter=0");
        }
        sb.append("&maxresults=");
        sb.append(maxResults);
        URL url = new URL(sb.toString());
        URLConnection urlConn = url.openConnection();
        urlConn.setDoOutput(true);
        urlConn.setUseCaches(false);
        urlConn.setRequestProperty("Content-Type", "audio/x-flac; rate=" + sampleRate);
        OutputStream outputStream = urlConn.getOutputStream();
        FileInputStream fileInputStream = new FileInputStream(inputFile);
        byte[] buffer = new byte[256];
        while (fileInputStream.read(buffer, 0, 256) != -1) {
            outputStream.write(buffer, 0, 256);
        }
        fileInputStream.close();
        outputStream.close();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlConn.getInputStream(), Charset.forName("UTF-8")));
        ArrayList<String> completeResponse = new ArrayList<String>();
        String response = br.readLine();
        while (response != null) {
            completeResponse.add(response);
            response = br.readLine();
        }
        br.close();
        return completeResponse.toArray(new String[completeResponse.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Languages {
        AUTO_DETECT("auto"),
        ARABIC_JORDAN("ar-JO"),
        ARABIC_LEBANON("ar-LB"),
        ARABIC_QATAR("ar-QA"),
        ARABIC_UAE("ar-AE"),
        ARABIC_MOROCCO("ar-MA"),
        ARABIC_IRAQ("ar-IQ"),
        ARABIC_ALGERIA("ar-DZ"),
        ARABIC_BAHRAIN("ar-BH"),
        ARABIC_LYBIA("ar-LY"),
        ARABIC_OMAN("ar-OM"),
        ARABIC_SAUDI_ARABIA("ar-SA"),
        ARABIC_TUNISIA("ar-TN"),
        ARABIC_YEMEN("ar-YE"),
        BASQUE("eu"),
        CATALAN("ca"),
        CZECH("cs"),
        DUTCH("nl-NL"),
        ENGLISH_AUSTRALIA("en-AU"),
        ENGLISH_CANADA("en-CA"),
        ENGLISH_INDIA("en-IN"),
        ENGLISH_NEW_ZEALAND("en-NZ"),
        ENGLISH_SOUTH_AFRICA("en-ZA"),
        ENGLISH_UK("en-GB"),
        ENGLISH_US("en-US"),
        FINNISH("fi"),
        FRENCH("fr-FR"),
        GALICIAN("gl"),
        GERMAN("de-DE"),
        HEBREW("he"),
        HUNGARIAN("hu"),
        ICELANDIC("is"),
        ITALIAN("it-IT"),
        INDONESIAN("id"),
        JAPANESE("ja"),
        KOREAN("ko"),
        LATIN("la"),
        CHINESE_SIMPLIFIED("zh-CN"),
        CHINESE_TRANDITIONAL("zh-TW"),
        CHINESE_HONGKONG("zh-HK"),
        CHINESE_CANTONESE("zh-yue"),
        MALAYSIAN("ms-MY"),
        NORWEGIAN("no-NO"),
        POLISH("pl"),
        PIG_LATIN("xx-piglatin"),
        PORTUGUESE("pt-PT"),
        PORTUGUESE_BRASIL("pt-BR"),
        ROMANIAN("ro-RO"),
        RUSSIAN("ru"),
        SERBIAN("sr-SP"),
        SLOVAK("sk"),
        SPANISH_ARGENTINA("es-AR"),
        SPANISH_BOLIVIA("es-BO"),
        SPANISH_CHILE("es-CL"),
        SPANISH_COLOMBIA("es-CO"),
        SPANISH_COSTA_RICA("es-CR"),
        SPANISH_DOMINICAN_REPUBLIC("es-DO"),
        SPANISH_ECUADOR("es-EC"),
        SPANISH_EL_SALVADOR("es-SV"),
        SPANISH_GUATEMALA("es-GT"),
        SPANISH_HONDURAS("es-HN"),
        SPANISH_MEXICO("es-MX"),
        SPANISH_NICARAGUA("es-NI"),
        SPANISH_PANAMA("es-PA"),
        SPANISH_PARAGUAY("es-PY"),
        SPANISH_PERU("es-PE"),
        SPANISH_PUERTO_RICO("es-PR"),
        SPANISH_SPAIN("es-ES"),
        SPANISH_US("es-US"),
        SPANISH_URUGUAY("es-UY"),
        SPANISH_VENEZUELA("es-VE"),
        SWEDISH("sv-SE"),
        TURKISH("tr"),
        ZULU("zu");

        private final String languageCode;

        private Languages(String languageCode) {
            this.languageCode = languageCode;
        }

        public String toString() {
            return this.languageCode;
        }
    }
}

