/*
 * Decompiled with CFR 0.152.
 */
package com.lksnext.sqlite.impl.util;

import com.lksnext.sqlite.impl.util.GenericTable;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.Constraint;
import org.jooq.CreateTableColumnStep;
import org.jooq.DSLContext;
import org.jooq.DataType;
import org.jooq.InsertSetMoreStep;
import org.jooq.InsertSetStep;
import org.jooq.Name;
import org.jooq.exception.DataAccessException;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public class ResultSetImporter {
    private static final String SQLITE_PK_COLUMN = "id";
    private static final String COLUMN_NAME_REGEX = "^(\\w+)(?:\\#(\\w+)\\#)?$";
    private static final String WITHOUT_ROWID_SQL = "WITHOUT ROWID";

    public static GenericTable convertResultSetSQLite(DSLContext create, ResultSet resultSet, String tableName) throws DataAccessException, SQLException {
        boolean first = true;
        boolean pkDefined = false;
        CreateTableColumnStep createTableQuery = create.createTable(tableName);
        GenericTable tableDefinition = new GenericTable(DSL.name((String)tableName));
        while (resultSet.next()) {
            InsertSetStep insertOperation = create.insertInto(DSL.table((Name)DSL.name((String)tableName)));
            InsertSetMoreStep lastStep = null;
            ResultSetMetaData rsmd = resultSet.getMetaData();
            int total_columns = resultSet.getMetaData().getColumnCount();
            String[] allColumns = new String[total_columns];
            for (int i = 0; i < total_columns; ++i) {
                String rawColumnName;
                Object value = null;
                String columnName = rawColumnName = rsmd.getColumnLabel(i + 1).toLowerCase();
                String forcedTypeName = null;
                Integer forcedType = null;
                if (columnName.equals("_id") || columnName.equals(SQLITE_PK_COLUMN)) {
                    columnName = SQLITE_PK_COLUMN;
                    pkDefined = true;
                    if (first) {
                        createTableQuery = createTableQuery.column(SQLITE_PK_COLUMN, SQLDataType.CLOB);
                    }
                } else {
                    Pattern pattern = Pattern.compile(COLUMN_NAME_REGEX);
                    Matcher matcher = pattern.matcher(rawColumnName);
                    if (matcher.matches()) {
                        columnName = matcher.group(1);
                        forcedTypeName = matcher.group(2);
                        if (forcedTypeName != null) {
                            forcedType = ResultSetImporter.translateForcedType(forcedTypeName);
                        }
                    }
                }
                int scale = 0;
                DataType columDataType = SQLDataType.CLOB;
                int sqlType = resultSet.getMetaData().getColumnType(i + 1);
                if (forcedType != null) {
                    sqlType = forcedType;
                }
                switch (sqlType) {
                    case -7: {
                        columDataType = SQLDataType.BOOLEAN;
                        value = resultSet.getBoolean(i + 1);
                    }
                    case -9: 
                    case 1: 
                    case 12: {
                        columDataType = SQLDataType.CLOB;
                        value = resultSet.getString(i + 1);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: {
                        scale = resultSet.getMetaData().getScale(i + 1);
                        if (scale == 0) {
                            columDataType = SQLDataType.INTEGER;
                            value = resultSet.getLong(i + 1);
                            break;
                        }
                        columDataType = SQLDataType.REAL;
                        value = resultSet.getBigDecimal(i + 1);
                        break;
                    }
                    case 8: {
                        scale = resultSet.getMetaData().getScale(i + 1);
                        columDataType = SQLDataType.REAL;
                        value = resultSet.getDouble(i + 1);
                        break;
                    }
                    case 4: {
                        columDataType = SQLDataType.INTEGER;
                        value = resultSet.getLong(i + 1);
                        break;
                    }
                    case 91: 
                    case 93: {
                        value = resultSet.getDate(i + 1);
                        if (value != null) {
                            if (forcedType != null && forcedType == sqlType) {
                                columDataType = forcedType.equals(93) ? SQLDataType.TIMESTAMP : SQLDataType.DATE;
                                break;
                            }
                            if (new SimpleDateFormat("HH:mm:ss").format((Date)value).equals("00:00:00")) {
                                columDataType = SQLDataType.DATE;
                                break;
                            }
                            columDataType = SQLDataType.TIMESTAMP;
                            break;
                        }
                        columDataType = SQLDataType.TIMESTAMP;
                    }
                }
                if (first) {
                    if (!SQLITE_PK_COLUMN.equals(columnName)) {
                        createTableQuery = createTableQuery.column(columnName, columDataType);
                        tableDefinition.addField(columnName, columDataType);
                    }
                    allColumns[i] = columnName;
                }
                lastStep = lastStep == null ? insertOperation.set(DSL.field((String)columnName), value) : lastStep.set(DSL.field((String)columnName), value);
            }
            if (first) {
                if (pkDefined) {
                    createTableQuery = createTableQuery.constraints(new Constraint[]{DSL.constraint((String)("PK_" + tableName)).primaryKey(new String[]{SQLITE_PK_COLUMN})});
                    String createTableSQL = createTableQuery.getSQL() + " " + WITHOUT_ROWID_SQL;
                    create.execute(createTableSQL);
                } else {
                    createTableQuery.constraints(new Constraint[]{DSL.constraint((String)("PK_" + tableName)).primaryKey(allColumns)});
                    String createTableSQL = createTableQuery.getSQL() + " " + WITHOUT_ROWID_SQL;
                    create.execute(createTableSQL);
                }
            }
            lastStep.execute();
            first = false;
        }
        return tableDefinition;
    }

    private static Integer translateForcedType(String typeName) {
        Class<Types> typesClass = Types.class;
        try {
            Field field = typesClass.getField(typeName.toUpperCase());
            return field.getInt(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

