/*
 * Decompiled with CFR 0.152.
 */
package com.lin;

import com.lin.custom.EnglishNameRandom;
import com.lin.datatype.DataType;
import com.lin.faker.Faker;
import com.lin.utils.DBTools;
import com.lin.value.Times;
import com.lin.value.Values;
import org.junit.Before;
import org.junit.Test;

public class Example {
    @Before
    public void setUp() {
        DBTools.dbName("facker").connect();
    }

    @Test
    public void testInsertByMapSuccess() {
        Faker.tableName("user").param("name", (Object)DataType.USERNAME).param("age", (Object)DataType.AGE).param("sex", (Object)DataType.SEX).param("address", (Object)DataType.ADDRESS).param("birthday", (Object)DataType.TIME).insertCount(5).execute();
    }

    @Test
    public void testInsertUseOfMethodWithString() {
        Faker.tableName("user").param("address", Values.of("\u5929\u6d25", "\u6b66\u6c49", "\u5317\u6d77", "\u4e91\u5357")).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUseOfMethodWithInteger() {
        Faker.tableName("user").param("age", Values.of(1, 3, 5, 7)).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUseOfMethodWithFloat() {
        Faker.tableName("user").param("age", Values.of(Float.valueOf(1.1f), Float.valueOf(3.2f), Float.valueOf(5.8f), Float.valueOf(7.6f))).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUseOfMethodWithDouble() {
        Faker.tableName("user").param("age", Values.of(1.1, 3.2, 5.8, 7.6)).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUseOfMethodWithLong() {
        Faker.tableName("user").param("age", Values.of(13L, 66L, 79L, 1584854856545L)).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUseOfMethodWithBoolean() {
        Faker.tableName("user").param("isGood", Values.of(true, false)).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUseOfMethodWithChar() {
        Faker.tableName("user").param("type", Values.of(Character.valueOf('A'), Character.valueOf('C'))).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertOnlyShowSql() {
        Faker.tableName("user").param("name", (Object)DataType.USERNAME).param("age", (Object)DataType.AGE).param("sex", (Object)DataType.SEX).param("address", (Object)DataType.ADDRESS).param("birthday", (Object)DataType.TIME).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUseCustomRandom() {
        Faker.tableName("user").param("name", EnglishNameRandom.class).param("age", (Object)DataType.AGE).param("sex", (Object)DataType.SEX).param("address", (Object)DataType.ADDRESS).param("birthday", (Object)DataType.TIME).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUserNameRandom() {
        Faker.tableName("user").param("name", (Object)DataType.USERNAME).insertCount(10).onlyShowSql();
    }

    @Test
    public void testInsertUseOfIntRange() {
        Faker.tableName("user").param("age", Values.ofIntRange(18, 33)).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertUseOfLongRange() {
        Faker.tableName("user").param("age", Values.ofLongRange(66666L, 8888888888L)).insertCount(5).onlyShowSql();
    }

    @Test
    public void testInsertValuesOfFloatRange() {
        Faker.tableName("user").param("age", Values.ofFloatRange(22.22f, 33.33f)).insertCount(10).onlyShowSql();
    }

    @Test
    public void testInsertValuesOfFloatRangeWithPrecision() {
        Faker.tableName("user").param("age", Values.ofFloatRange(1666.66f, 8888.88f, 6)).insertCount(10).onlyShowSql();
    }

    @Test
    public void testInsertValuesOfDoubleRange() {
        Faker.tableName("user").param("age", Values.ofDoubleRange(11.11, 55.55)).insertCount(10).onlyShowSql();
    }

    @Test
    public void testInsertValuesOfDoubleRangeWithPrecision() {
        Faker.tableName("user").param("age", Values.ofDoubleRange(3333.333, 8888.88, 4)).insertCount(10).onlyShowSql();
    }

    @Test
    public void testInsertValuesOfTimeRange() {
        Faker.tableName("user").param("birthday", Values.ofTimeRange(Times.of(2016, 3, 12), Times.of(2018, 4, 22))).insertCount(10).onlyShowSql();
    }

    @Test
    public void testInsertValuesOfTimeRangeToSecond() {
        Faker.tableName("user").param("birthday", Values.ofTimeRange(Times.of(2016, 3, 12, 5, 12, 33), Times.of(2018, 4, 22, 7, 14, 22))).insertCount(10).onlyShowSql();
    }

    @Test
    public void testInsertAgeRandom() {
        Faker.tableName("user").param("age", (Object)DataType.AGE).insertCount(10).onlyShowSql();
    }

    @Test
    public void testInsertIgnored() {
        Faker.tableName("test").param("email", (Object)DataType.EMAIL).insertCount(10).ignored();
    }
}

