/*
 * Decompiled with CFR 0.152.
 */
package com.liys.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.liys.view.LineBaseProView;

public class LineProView
extends LineBaseProView {
    protected Path pathLight = new Path();
    protected Path pathStroke = new Path();
    protected int offTextX;

    public LineProView(Context context) {
        this(context, null);
    }

    public LineProView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LineProView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void init() {
        this.offTextX = this.dp2px(10.0f);
        if (this.isRadius && this.radius == -1.0f) {
            this.radius = this.progressSize / 2;
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.pathIn.reset();
        this.pathOut.reset();
        this.pathLight.reset();
        this.pathStroke.reset();
        double progressLength = this.progress / this.maxProgress * (double)(this.width - this.blankSpace);
        int top = (this.height - this.progressSize) / 2;
        RectF rectFIn = new RectF((float)this.blankSpace, (float)top, (float)(this.width - this.blankSpace), (float)(top + this.progressSize));
        RectF rectFOut = new RectF((float)this.blankSpace, (float)top, (float)((int)progressLength), (float)(top + this.progressSize));
        RectF rectFStroke = new RectF((float)(this.blankSpace + this.strokeWidth / 2), (float)(top + this.strokeWidth / 2), (float)(this.width - this.blankSpace - this.strokeWidth / 2), (float)(top + this.progressSize - this.strokeWidth / 2));
        this.refreshRadius();
        this.pathIn.addRoundRect(rectFIn, this.floatsIn, Path.Direction.CW);
        this.pathOut.addRoundRect(rectFOut, this.floatsOut, Path.Direction.CW);
        this.pathLight.addRoundRect(rectFIn, this.floatsIn, Path.Direction.CW);
        this.pathStroke.addRoundRect(rectFStroke, this.floatsIn, Path.Direction.CW);
        this.pathOut.op(this.pathIn, Path.Op.INTERSECT);
        if (this.lightShow) {
            canvas.drawPath(this.pathLight, this.lightPaint);
        }
        canvas.drawPath(this.pathIn, this.progressBgPaint);
        canvas.drawPath(this.pathOut, this.progressPaint);
        if (this.strokeShow) {
            canvas.drawPath(this.pathStroke, this.strokePaint);
        }
        this.drawText(canvas, progressLength);
    }

    protected void drawText(Canvas canvas, double progressLength) {
        if (this.textShow) {
            int startX = this.dp2px(10.0f) + this.blankSpace;
            int endX = startX + this.getTextRect(this.text).width() + this.offTextX;
            if ((double)endX < progressLength) {
                startX = (int)progressLength - this.getTextRect(this.text).width() - this.offTextX;
            }
            canvas.drawText(this.text, (float)startX, (float)this.getBaseline(this.textPaint), this.textPaint);
        }
    }

    public int getOffTextX() {
        return this.offTextX;
    }

    public void setOffTextX(int offTextX) {
        this.offTextX = offTextX;
    }
}

