/*
 * Decompiled with CFR 0.152.
 */
package com.liys.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.liys.view.LineBaseProView;
import com.liys.view.R;

public class LineCentreProView
extends LineBaseProView {
    protected Paint boxPaint = new Paint();
    protected int boxWidth;
    protected int boxRadius;

    public LineCentreProView(Context context) {
        this(context, null);
    }

    public LineCentreProView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LineCentreProView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LineCentreProView);
        this.boxWidth = typedArray.getDimensionPixelOffset(R.styleable.LineCentreProView_box_width, -1);
        this.boxRadius = typedArray.getDimensionPixelOffset(R.styleable.LineCentreProView_box_radius, -1);
    }

    @Override
    public void init() {
        this.boxPaint.setAntiAlias(true);
        this.boxPaint.setColor(this.progressPaint.getColor());
        if (this.boxWidth == -1) {
            this.boxWidth = this.height * 3 / 2;
        }
        if (this.boxRadius == -1) {
            this.boxRadius = this.height / 2;
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        int outWidth = (int)(this.progress / this.maxProgress * (double)this.width);
        if (outWidth >= this.width - this.boxWidth) {
            outWidth = this.width - this.boxWidth;
        }
        int top = (this.height - this.progressSize) / 2;
        canvas.drawRoundRect(new RectF(0.0f, (float)top, (float)this.width, (float)(top + this.progressSize)), this.radius, this.radius, this.progressBgPaint);
        canvas.drawRoundRect(new RectF(0.0f, (float)top, (float)(outWidth + this.boxWidth / 2), (float)(top + this.progressSize)), this.radius, this.radius, this.progressPaint);
        this.drawBox(canvas, outWidth);
        this.drawText(canvas, outWidth);
    }

    public void drawBox(Canvas canvas, int left) {
        RectF rectF = new RectF((float)left, 0.0f, (float)(left + this.boxWidth), (float)this.height);
        canvas.drawRoundRect(rectF, (float)this.boxRadius, (float)this.boxRadius, this.boxPaint);
    }

    public void drawText(Canvas canvas, int left) {
        canvas.drawText(this.text, (float)(left + this.boxWidth / 2 - this.getTextRect(this.text).width() / 2), (float)this.getBaseline(this.textPaint), this.textPaint);
    }

    public Paint getBoxPaint() {
        return this.boxPaint;
    }

    public void setBoxPaint(Paint boxPaint) {
        this.boxPaint = boxPaint;
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        this.invalidate();
    }

    public int getBoxRadius() {
        return this.boxRadius;
    }

    public void setBoxRadius(int boxRadius) {
        this.boxRadius = boxRadius;
        this.invalidate();
    }
}

