/*
 * Decompiled with CFR 0.152.
 */
package com.liys.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import com.liys.view.LineBaseProView;
import com.liys.view.R;

public class LineBottomProView
extends LineBaseProView {
    protected Paint boxPaint = new Paint();
    protected int boxWidth;
    protected int boxHeight;
    protected int boxRadius;

    public LineBottomProView(Context context) {
        this(context, null);
    }

    public LineBottomProView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LineBottomProView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.LineBottomProView);
        this.boxWidth = typedArray.getDimensionPixelOffset(R.styleable.LineBottomProView_box_width, -1);
        this.boxHeight = typedArray.getDimensionPixelOffset(R.styleable.LineBottomProView_box_height, -1);
        this.boxRadius = typedArray.getDimensionPixelOffset(R.styleable.LineBottomProView_box_radius, -1);
    }

    @Override
    public void init() {
        this.boxPaint.setAntiAlias(true);
        this.boxPaint.setColor(this.progressPaint.getColor());
        if (this.progressSize == this.height) {
            this.progressSize = this.height / 5 * 2;
        }
        if (this.boxHeight == -1) {
            this.boxHeight = this.height / 5 * 2;
        }
        if (this.boxWidth == -1) {
            this.boxWidth = this.boxHeight * 2;
        }
        if (this.boxRadius == -1) {
            this.boxRadius = this.dp2px(5.0f);
        }
    }

    @SuppressLint(value={"DrawAllocation"})
    protected void onDraw(Canvas canvas) {
        this.pathIn.reset();
        this.pathOut.reset();
        int outWidth = (int)(this.progress / this.maxProgress * (double)(this.width - this.boxWidth));
        int top = this.height - this.progressSize;
        this.refreshRadius();
        this.pathIn.addRoundRect(new RectF((float)(this.boxWidth / 2), (float)top, (float)(this.width - this.boxWidth / 2), (float)(top + this.progressSize)), this.floatsIn, Path.Direction.CW);
        this.pathOut.addRoundRect(new RectF((float)(this.boxWidth / 2), (float)top, (float)(outWidth + this.boxWidth / 2), (float)(top + this.progressSize)), this.floatsOut, Path.Direction.CW);
        this.pathOut.op(this.pathIn, Path.Op.INTERSECT);
        canvas.drawPath(this.pathIn, this.progressBgPaint);
        canvas.drawPath(this.pathOut, this.progressPaint);
        this.drawBox(canvas, outWidth);
        this.drawText(canvas, outWidth);
    }

    public void drawBox(Canvas canvas, int left) {
        RectF rectF = new RectF((float)left, 0.0f, (float)(left + this.boxWidth), (float)this.boxHeight);
        canvas.drawRoundRect(rectF, (float)this.boxRadius, (float)this.boxRadius, this.boxPaint);
        Path path = new Path();
        path.moveTo((float)(left + this.boxWidth / 2 - this.sp2px(4.0f)), (float)this.boxHeight);
        path.lineTo((float)(left + this.boxWidth / 2 + this.sp2px(4.0f)), (float)this.boxHeight);
        path.lineTo((float)(left + this.boxWidth / 2), (float)(this.height - this.progressSize - 2));
        path.close();
        canvas.drawPath(path, this.boxPaint);
    }

    public void drawText(Canvas canvas, int left) {
        canvas.drawText(this.text, (float)(left + this.boxWidth / 2 - this.getTextRect(this.text).width() / 2), (float)this.getBaseline(this.textPaint, this.boxHeight), this.textPaint);
    }

    public Paint getBoxPaint() {
        return this.boxPaint;
    }

    public void setBoxPaint(Paint boxPaint) {
        this.boxPaint = boxPaint;
    }

    public int getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(int boxWidth) {
        this.boxWidth = boxWidth;
        this.invalidate();
    }

    public int getBoxRadius() {
        return this.boxRadius;
    }

    public void setBoxRadius(int boxRadius) {
        this.boxRadius = boxRadius;
        this.invalidate();
    }
}

