/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.client;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.client.LocalResponseHandler;
import weixin.popular.util.JsonUtil;

public class JsonResponseHandler {
    private static Logger logger = LoggerFactory.getLogger(JsonResponseHandler.class);

    public static <T> ResponseHandler<T> createResponseHandler(Class<T> clazz) {
        return new JsonResponseHandlerImpl<T>(null, clazz);
    }

    public static class JsonResponseHandlerImpl<T>
    extends LocalResponseHandler
    implements ResponseHandler<T> {
        private Class<T> clazz;

        public JsonResponseHandlerImpl(String uriId, Class<T> clazz) {
            this.uriId = uriId;
            this.clazz = clazz;
        }

        public T handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                String str = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                logger.info("URI[{}] elapsed time:{} ms RESPONSE DATA:{}", new Object[]{this.uriId, System.currentTimeMillis() - this.startTime, str});
                return JsonUtil.parseObject(str, this.clazz);
            }
            throw new ClientProtocolException("Unexpected response status: " + status);
        }
    }
}

