/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.cxf;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.endpoint.Server;
import org.liveSense.service.cxf.ThreadLocalRequestContext;
import org.liveSense.service.cxf.WebServiceRegistrationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceThreadLocalRequestFilter
implements Filter {
    private final Logger LOG = LoggerFactory.getLogger(WebServiceThreadLocalRequestFilter.class);
    private static WebServiceRegistrationListener listener;

    public void setWebServiceRegistrationListener(WebServiceRegistrationListener listener) {
        WebServiceThreadLocalRequestFilter.listener = listener;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Server server = null;
        if (listener != null) {
            server = listener.getServiceByRequest((HttpServletRequest)request);
        }
        ThreadLocalRequestContext.getThreadLocal().set(new ThreadLocalRequestContext((HttpServletRequest)request, (HttpServletResponse)response, server));
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        this.LOG.info("init()");
    }

    public void destroy() {
    }

    public static HttpServletRequest getThreadLocalRequest() {
        return ThreadLocalRequestContext.getRequestContext().getRequest();
    }

    public static HttpServletResponse getThreadLocalResponse() {
        return ThreadLocalRequestContext.getRequestContext().getResponse();
    }

    public static Server getWebServiceServer() {
        return ThreadLocalRequestContext.getRequestContext().getServer();
    }
}

