/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.cxf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.SingletonResourceProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.liveSense.core.service.OSGIClassLoaderManager;
import org.liveSense.service.cxf.WebServiceMarkerInterface;
import org.liveSense.service.cxf.WebServiceThreadLocalRequestFilter;
import org.liveSense.service.cxf.WebServiceThreadLocalWebServiceContextInterceptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, metatype=true)
@Properties(value={@Property(name="root", value={"/webservices"})})
public class WebServiceRegistrationListener
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    public static final String WS_INTERFACE = "org.liveSense.ws.interface";
    public static final String WS_PATH = "org.liveSense.service.webservice.path";
    public static final String WS_TYPE = "org.liveSense.service.webservice.type";
    public static final String PROP_SERVICE_ROOT_URL = "root";
    public static final String DEFAULT_SERVICE_ROOT_URL = "/webservices";
    private String serviceRootUrl = "root";
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private HttpService osgiHttpService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private AuthenticationSupport slingAuthenticator;
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    private MimeTypeService mimeTypeService;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    private OSGIClassLoaderManager osgiClassLoaderManager;
    private Bus bus;
    private BundleContext context;
    private DestinationRegistry destinationRegistry;
    private WebServiceThreadLocalRequestFilter filter;
    private ServiceRegistration filterRegistration;
    private ServiceTracker httpServiceTracker;
    Map<String, HttpServlet> registeredServlets = new ConcurrentHashMap<String, HttpServlet>();
    Map<String, Server> registeredServices = new ConcurrentHashMap<String, Server>();
    private final Logger log = LoggerFactory.getLogger(WebServiceRegistrationListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate(ComponentContext context) {
        block14: {
            this.log.info("Activating WebServiceRegistrationListener");
            this.context = context.getBundleContext();
            this.serviceRootUrl = PropertiesUtil.toString(context.getProperties().get(PROP_SERVICE_ROOT_URL), (String)DEFAULT_SERVICE_ROOT_URL);
            try {
                this.bus = BusFactory.newInstance().createBus();
                DestinationFactoryManager dfm = (DestinationFactoryManager)this.bus.getExtension(DestinationFactoryManager.class);
                this.destinationRegistry = null;
                try {
                    DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
                    if (df instanceof HTTPTransportFactory) {
                        HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                        this.destinationRegistry = transportFactory.getRegistry();
                    }
                }
                catch (BusException e) {
                    this.log.warn("DestinationFactoryManager not found", (Throwable)e);
                }
                if (this.destinationRegistry == null) break block14;
                HttpContext httpContext = new HttpContext(){

                    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
                        return true;
                    }

                    public URL getResource(String name) {
                        return null;
                    }

                    public String getMimeType(String name) {
                        MimeTypeService mts = WebServiceRegistrationListener.this.mimeTypeService;
                        return mts != null ? mts.getMimeType(name) : null;
                    }
                };
                CXFNonSpringServlet cxfServlet = new CXFNonSpringServlet(this.destinationRegistry, false);
                this.registeredServlets.put(this.serviceRootUrl, (HttpServlet)cxfServlet);
                try {
                    this.log.info("Registering CXF Root servlet: " + this.serviceRootUrl);
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("alias", this.serviceRootUrl);
                    this.osgiHttpService.registerServlet(this.serviceRootUrl, (Servlet)cxfServlet, props, httpContext);
                    this.log.info("Registering WebServiceThreadLocalRequestFilter");
                    Hashtable<String, String> filterProps = new Hashtable<String, String>();
                    ((Dictionary)filterProps).put("pattern", this.serviceRootUrl + "/.*");
                    ((Dictionary)filterProps).put("alias", this.serviceRootUrl);
                    ((Dictionary)filterProps).put("init.message", "WebServiceThreadLocalRequestFilter!");
                    ((Dictionary)filterProps).put("service.ranking", "1");
                    this.filter = new WebServiceThreadLocalRequestFilter();
                    this.filter.setWebServiceRegistrationListener(this);
                    this.filterRegistration = context.getBundleContext().registerService(Filter.class.getName(), (Object)this.filter, filterProps);
                }
                catch (ServletException e) {
                    this.log.error("Error on servlet registration: " + this.serviceRootUrl, (Throwable)e);
                }
                catch (NamespaceException e) {
                    this.log.error("Could not register servlet to URL: " + this.serviceRootUrl + " (Another servlet on URL?)", (Throwable)e);
                }
            }
            catch (Throwable th) {
                this.log.error("Error on activation", th);
            }
        }
        try {
            ServiceReference[] refs = this.context.getAllServiceReferences(WebServiceMarkerInterface.class.getName(), null);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    this.registerService(ref);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            this.log.error("Cannot get sercive references");
        }
        this.log.info("Adding OSGi service listener");
        context.getBundleContext().addServiceListener((ServiceListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected void deactivate(ComponentContext context) {
        this.log.info("Deactivating WebServiceRegistrationListener");
        for (String path : this.registeredServices.keySet()) {
            try {
                this.log.info("Stopping service: " + path);
                if (this.registeredServices.get(path).isStarted()) {
                    this.registeredServices.get(path).stop();
                }
                this.log.info("Destroy service: " + path);
                this.registeredServices.get(path).destroy();
            }
            catch (Exception e) {
                this.log.error("Could not destroy WebService: " + path);
            }
        }
        try {
            this.log.info("Remove OSGi service listener");
            context.getBundleContext().removeServiceListener((ServiceListener)this);
        }
        catch (Exception e) {
            this.log.error("Could not get unregister service listener", (Throwable)e);
        }
        if (this.filterRegistration != null) {
            this.log.info("Unregistering WebServiceThreadLocalRequestFilter");
            try {
                context.getBundleContext().ungetService(this.filterRegistration.getReference());
            }
            catch (Exception e) {
                this.log.error("Could not unregister WebServiceThreadLocalRequestFilter", (Throwable)e);
            }
        }
        for (String serv : this.registeredServlets.keySet()) {
            try {
                this.log.info("Unregistering servlet: " + serv);
                this.osgiHttpService.unregister(serv);
            }
            catch (Exception e) {
                this.log.error("Could not remove: " + serv, (Throwable)e);
            }
        }
        this.registeredServlets.clear();
        if (this.destinationRegistry != null) {
            for (String path : this.destinationRegistry.getDestinationsPaths()) {
                AbstractHTTPDestination dest;
                AbstractHTTPDestination abstractHTTPDestination = dest = this.destinationRegistry.getDestinationForPath(path);
                synchronized (abstractHTTPDestination) {
                    this.destinationRegistry.removeDestination(path);
                    dest.releaseRegistry();
                }
            }
            this.destinationRegistry = null;
        }
        this.bus = null;
    }

    private void unregisterService(ServiceReference sr) {
        String serviceUrl = (String)sr.getProperty(WS_PATH);
        if (serviceUrl != null && this.context.getService(sr) instanceof WebServiceMarkerInterface && this.registeredServices.containsKey(serviceUrl)) {
            this.log.info("Service unregistration: " + this.context.getService(sr).getClass().getName());
            Server service = this.registeredServices.get(serviceUrl);
            this.registeredServices.remove(serviceUrl);
            try {
                if (service.isStarted()) {
                    service.stop();
                }
                service.destroy();
            }
            catch (Exception e) {
                this.log.error("Could not remove service: " + serviceUrl, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(ServiceReference sr) {
        String serviceUrl = (String)sr.getProperty(WS_PATH);
        if (serviceUrl != null && this.context.getService(sr) instanceof WebServiceMarkerInterface && !this.registeredServlets.containsKey(serviceUrl)) {
            ClassLoaderUtils.ClassLoaderHolder oldClassLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)Bus.class.getClassLoader());
            String type = this.getServiceType(sr);
            try {
                Class<?> serviceClass = this.getServiceClass(sr);
                if (serviceClass == null) {
                    serviceClass = this.context.getService(sr).getClass();
                }
                this.log.info(type + " WebService registration: " + serviceUrl + " Interface: " + serviceClass + " Implementation: " + this.context.getService(sr).getClass().getName());
                if (type.equalsIgnoreCase("jaxws")) {
                    JaxWsServerFactoryBean sf = new JaxWsServerFactoryBean();
                    sf.setBus(this.bus);
                    sf.setAddress(serviceUrl);
                    sf.setServiceClass(serviceClass);
                    sf.getServiceFactory().setDataBinding((DataBinding)new JAXBDataBinding());
                    sf.setServiceBean(this.context.getService(sr));
                    this.registeredServices.put(serviceUrl, sf.create());
                    this.registeredServices.get(serviceUrl).getEndpoint().getInInterceptors().add(new WebServiceThreadLocalWebServiceContextInterceptor(null));
                } else if (type.equalsIgnoreCase("aegis")) {
                    ServerFactoryBean sf = new ServerFactoryBean();
                    sf.setBus(this.bus);
                    sf.setAddress(serviceUrl);
                    sf.setServiceClass(serviceClass);
                    sf.getServiceFactory().setDataBinding((DataBinding)new AegisDatabinding());
                    sf.setServiceBean(this.context.getService(sr));
                    this.registeredServices.put(serviceUrl, sf.create());
                    this.registeredServices.get(serviceUrl).getEndpoint().getInInterceptors().add(new WebServiceThreadLocalWebServiceContextInterceptor(null));
                } else if (type.equalsIgnoreCase("jaxrs")) {
                    this.createJaxRsService(serviceUrl, serviceClass, this.context.getService(sr));
                }
            }
            catch (Exception e) {
                this.log.error("Coluld not register " + type + " service: " + serviceUrl, (Throwable)e);
            }
            finally {
                if (oldClassLoader != null) {
                    oldClassLoader.reset();
                }
            }
        }
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference sr = event.getServiceReference();
        switch (event.getType()) {
            case 1: {
                this.registerService(sr);
                break;
            }
            case 4: {
                this.unregisterService(sr);
                break;
            }
        }
    }

    private String getServiceType(ServiceReference sr) {
        String type = "aegis";
        if (sr.getProperty(WS_TYPE) != null && ((type = PropertiesUtil.toString((Object)sr.getProperty(WS_TYPE), null)) == null || !type.equalsIgnoreCase("jaxrs") && !type.equalsIgnoreCase("jaxws"))) {
            type = "aegis";
        }
        return type;
    }

    private Class getServiceClass(ServiceReference sr) {
        Class<?> clazz = null;
        if (sr.getProperty(WS_INTERFACE) != null) {
            String servinterface = PropertiesUtil.toString((Object)sr.getProperty(WS_INTERFACE), null);
            try {
                clazz = this.context.getService(sr).getClass().getClassLoader().loadClass(servinterface).getClass();
            }
            catch (Exception e) {
                this.log.error("Could not load interface " + servinterface + " for service " + this.context.getService(sr).getClass().getName() + " " + sr.getBundle().getSymbolicName() + "(" + sr.getBundle().getBundleId() + ")");
            }
        }
        return clazz;
    }

    private void createJaxRsService(String serviceUrl, Class serviceInterface, Object serviceBean) {
        JAXRSServerFactoryBean sf = new JAXRSServerFactoryBean();
        sf.setBus(this.bus);
        sf.setAddress(serviceUrl);
        HashMap<String, String> extensionMappings = new HashMap<String, String>();
        extensionMappings.put("xml", "application/xml");
        extensionMappings.put("json", "application/json");
        sf.setExtensionMappings(extensionMappings);
        ArrayList<Object> providers = new ArrayList<Object>();
        providers.add(new JAXBElementProvider());
        JacksonJaxbJsonProvider jp = new JacksonJaxbJsonProvider();
        try {
            jp.writeTo((Object)new Long(1L), Long.class, Long.class, new Annotation[0], MediaType.APPLICATION_JSON_TYPE, null, (OutputStream)new ByteArrayOutputStream());
        }
        catch (Throwable e) {
            // empty catch block
        }
        providers.add(jp);
        sf.setProviders(providers);
        BindingFactoryManager manager = (BindingFactoryManager)sf.getBus().getExtension(BindingFactoryManager.class);
        JAXRSBindingFactory factory = new JAXRSBindingFactory();
        factory.setBus(sf.getBus());
        manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)factory);
        sf.setResourceClasses(new Class[]{serviceInterface == null ? serviceBean.getClass() : serviceInterface});
        sf.setBindingId("http://apache.org/cxf/binding/jaxrs");
        sf.setResourceProvider(serviceInterface == null ? serviceBean.getClass() : serviceInterface, (ResourceProvider)new SingletonResourceProvider(serviceBean));
        this.registeredServices.put(serviceUrl, sf.create());
    }

    public Server getServiceByPath(String path) {
        return this.registeredServices.get(path);
    }

    public Server getServiceByRequest(HttpServletRequest request) {
        String pathInfo;
        String string = pathInfo = request.getPathInfo() == null ? request.getServletPath() : request.getPathInfo();
        if (pathInfo.startsWith(this.serviceRootUrl)) {
            pathInfo = pathInfo.substring(this.serviceRootUrl.length());
        }
        for (String path : this.registeredServices.keySet()) {
            EndpointInfo ei;
            AbstractHTTPDestination d = this.destinationRegistry.getDestinationForPath(pathInfo, true);
            if (d == null) {
                d = this.destinationRegistry.checkRestfulRequest(pathInfo);
            }
            if (d == null || !(ei = d.getEndpointInfo()).getAddress().equals(this.registeredServices.get(path).getEndpoint().getEndpointInfo().getAddress())) continue;
            return this.registeredServices.get(path);
        }
        return null;
    }

    protected void bindOsgiHttpService(HttpService httpService) {
        this.osgiHttpService = httpService;
    }

    protected void unbindOsgiHttpService(HttpService httpService) {
        if (this.osgiHttpService == httpService) {
            this.osgiHttpService = null;
        }
    }

    protected void bindSlingAuthenticator(AuthenticationSupport authenticationSupport) {
        this.slingAuthenticator = authenticationSupport;
    }

    protected void unbindSlingAuthenticator(AuthenticationSupport authenticationSupport) {
        if (this.slingAuthenticator == authenticationSupport) {
            this.slingAuthenticator = null;
        }
    }

    protected void bindMimeTypeService(MimeTypeService mimeTypeService) {
        this.mimeTypeService = mimeTypeService;
    }

    protected void unbindMimeTypeService(MimeTypeService mimeTypeService) {
        if (this.mimeTypeService == mimeTypeService) {
            this.mimeTypeService = null;
        }
    }

    protected void bindOsgiClassLoaderManager(OSGIClassLoaderManager oSGIClassLoaderManager) {
        this.osgiClassLoaderManager = oSGIClassLoaderManager;
    }

    protected void unbindOsgiClassLoaderManager(OSGIClassLoaderManager oSGIClassLoaderManager) {
        if (this.osgiClassLoaderManager == oSGIClassLoaderManager) {
            this.osgiClassLoaderManager = null;
        }
    }
}

