/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.cxf;

import org.apache.cxf.BusFactory;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.liveSense.service.cxf.OsgiAwareJaxWsClientFactoryBean;

public class JaxWsClientFactory {
    private JaxWsClientFactory() {
    }

    public static <T> T create(Class<T> pClass, String pPortUrl) {
        return JaxWsClientFactory.create(pClass, pPortUrl, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T create(Class<T> pClass, String pPortUrl, String pUsername, String pPassword) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(BusFactory.class.getClassLoader());
            JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean((ClientFactoryBean)new OsgiAwareJaxWsClientFactoryBean());
            factory.setServiceClass(pClass);
            factory.setAddress(pPortUrl);
            factory.setUsername(pUsername);
            factory.setPassword(pPassword);
            Object object = factory.create();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }
}

