/*
 * Decompiled with CFR 0.152.
 */
package org.liveSense.service.cxf;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.DestinationFactoryManager;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.cxf.transport.servlet.AbstractHTTPServlet;
import org.apache.cxf.transport.servlet.ServletContextResourceResolver;
import org.apache.cxf.transport.servlet.ServletController;
import org.apache.cxf.transport.servlet.servicelist.ServiceListGeneratorServlet;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.auth.core.AuthenticationSupport;
import org.liveSense.core.service.OSGIClassLoaderManager;
import org.liveSense.service.cxf.SoapRequestWrapper;
import org.liveSense.service.cxf.ThreadLocalRequestContext;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@Component(componentAbstract=true, metatype=true)
public abstract class AbstractWsServer
extends AbstractHTTPServlet {
    private static final long serialVersionUID = 1L;
    @Reference(bind="bindAuth", unbind="unbindAuth")
    AuthenticationSupport auth = null;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    PackageAdmin packageAdmin;
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY, policy=ReferencePolicy.DYNAMIC)
    OSGIClassLoaderManager dynamicClassLoader = null;
    private DestinationRegistry destinationRegistry;
    private Bus bus;
    private ServletController controller;
    private ClassLoader loader;
    private final boolean loadBus = true;
    private String servletUrl = null;
    private final Logger log = LoggerFactory.getLogger((String)"SOAP");
    BundleContext context = null;

    public abstract void callInit() throws Throwable;

    public abstract void callFinal() throws Throwable;

    protected void setBundleContext(BundleContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(HttpServletRequest pRequest, HttpServletResponse pResponse) throws ServletException {
        ThreadLocalRequestContext.getThreadLocal().set(new ThreadLocalRequestContext(pRequest, pResponse, null));
        try {
            if (this.auth != null) {
                this.auth.handleSecurity(pRequest, pResponse);
            }
            try {
                this.callInit();
            }
            catch (Throwable e) {
                throw new ServletException("Error on callInit", e);
            }
            ClassLoaderUtils.ClassLoaderHolder origLoader = null;
            try {
                if (this.loader != null) {
                    origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
                }
                if (this.bus != null) {
                    BusFactory.setThreadDefaultBus((Bus)this.bus);
                }
                this.controller.invoke((HttpServletRequest)new SoapRequestWrapper(pRequest, this.servletUrl), pResponse);
            }
            finally {
                BusFactory.setThreadDefaultBus(null);
                if (origLoader != null) {
                    origLoader.reset();
                }
            }
        }
        finally {
            try {
                this.callFinal();
            }
            catch (Throwable e) {
                this.log.error("callFinal: ", e);
            }
            ThreadLocalRequestContext.getThreadLocal().remove();
        }
    }

    protected HttpServletRequest getThreadLocalRequest() {
        ThreadLocalRequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        if (requestContext == null) {
            throw new IllegalStateException("No current soap request context available.");
        }
        return requestContext.getRequest();
    }

    protected HttpServletResponse getThreadLocalResponse() {
        ThreadLocalRequestContext requestContext = ThreadLocalRequestContext.getRequestContext();
        if (requestContext == null) {
            throw new IllegalStateException("No current soap request context available.");
        }
        return requestContext.getResponse();
    }

    protected String getUser() {
        return (String)this.getThreadLocalRequest().getAttribute("org.osgi.service.http.authentication.remote.user");
    }

    protected String getServletUrl() {
        return this.servletUrl;
    }

    protected void setServletUrl(String servletUrl) {
        this.servletUrl = servletUrl;
    }

    protected abstract Class getServerInterfaceType();

    protected void bindAuth(AuthenticationSupport auth) {
        this.auth = auth;
    }

    protected void unbindAuth(AuthenticationSupport auth) {
        this.auth = null;
    }

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        if (this.bus == null) {
            this.loadBus(sc);
        }
        if (this.bus != null) {
            this.loader = (ClassLoader)this.bus.getExtension(ClassLoader.class);
            ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
            resourceManager.addResourceResolver((ResourceResolver)new ServletContextResourceResolver(sc.getServletContext()));
            if (this.destinationRegistry == null) {
                this.destinationRegistry = AbstractWsServer.getDestinationRegistryFromBus(this.bus);
            }
        }
        this.controller = this.createServletController(sc);
    }

    private static DestinationRegistry getDestinationRegistryFromBus(Bus bus) {
        DestinationFactoryManager dfm = (DestinationFactoryManager)bus.getExtension(DestinationFactoryManager.class);
        try {
            DestinationFactory df = dfm.getDestinationFactory("http://cxf.apache.org/transports/http/configuration");
            if (df instanceof HTTPTransportFactory) {
                HTTPTransportFactory transportFactory = (HTTPTransportFactory)df;
                return transportFactory.getRegistry();
            }
        }
        catch (BusException busException) {
            // empty catch block
        }
        return null;
    }

    protected void loadBus(ServletConfig sc) {
        this.bus = BusFactory.newInstance().createBus();
    }

    private ServletController createServletController(ServletConfig servletConfig) {
        ServiceListGeneratorServlet serviceListGeneratorServlet = new ServiceListGeneratorServlet(this.destinationRegistry, this.bus);
        ServletController newController = new ServletController(this.destinationRegistry, servletConfig, (HttpServlet)serviceListGeneratorServlet);
        return newController;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        for (String path : this.destinationRegistry.getDestinationsPaths()) {
            AbstractHTTPDestination dest;
            AbstractHTTPDestination abstractHTTPDestination = dest = this.destinationRegistry.getDestinationForPath(path);
            synchronized (abstractHTTPDestination) {
                this.destinationRegistry.removeDestination(path);
                dest.releaseRegistry();
            }
        }
        this.destinationRegistry = null;
        this.destroyBus();
    }

    public void destroyBus() {
        if (this.bus != null) {
            this.bus.shutdown(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object origLoader = null;
        Bus origBus = null;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            try {
                if (this.bus != null) {
                    origBus = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
                }
                if (this.controller.filter((HttpServletRequest)request, (HttpServletResponse)response)) {
                    return;
                }
            }
            finally {
                if (origLoader != null) {
                    origLoader.reset();
                }
            }
        }
        chain.doFilter(request, response);
    }

    protected void bindPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    protected void unbindPackageAdmin(PackageAdmin packageAdmin) {
        if (this.packageAdmin == packageAdmin) {
            this.packageAdmin = null;
        }
    }

    protected void bindDynamicClassLoader(OSGIClassLoaderManager oSGIClassLoaderManager) {
        this.dynamicClassLoader = oSGIClassLoaderManager;
    }

    protected void unbindDynamicClassLoader(OSGIClassLoaderManager oSGIClassLoaderManager) {
        if (this.dynamicClassLoader == oSGIClassLoaderManager) {
            this.dynamicClassLoader = null;
        }
    }
}

