/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.net.Uri;
import android.webkit.ConsoleMessage;
import android.webkit.PermissionRequest;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import com.livechatinc.inappchat.ChatWindowErrorType;
import com.livechatinc.inappchat.ChatWindowPresenter;
import com.livechatinc.inappchat.ChatWindowViewImpl;
import com.livechatinc.inappchat.FileChooserMode;

class LCWebChromeClient
extends WebChromeClient {
    final ChatWindowViewImpl view;
    final ChatWindowPresenter presenter;

    LCWebChromeClient(ChatWindowViewImpl view, ChatWindowPresenter presenter) {
        this.view = view;
        this.presenter = presenter;
    }

    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> uploadMsg, WebChromeClient.FileChooserParams fileChooserParams) {
        this.view.chooseUriArrayToUpload(uploadMsg, this.toInternalMode(fileChooserParams.getMode()));
        return true;
    }

    private FileChooserMode toInternalMode(int mode) {
        return mode == 1 ? FileChooserMode.MULTIPLE : FileChooserMode.SINGLE;
    }

    public void onPermissionRequest(PermissionRequest request) {
        this.view.webRequestPermissions = request;
        String[] runtimePermissions = new String[]{"android.permission.RECORD_AUDIO", "android.permission.CAMERA", "android.permission.MODIFY_AUDIO_SETTINGS"};
        this.presenter.eventsListener.onRequestAudioPermissions(runtimePermissions, 89292);
    }

    public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
        if (consoleMessage.messageLevel() == ConsoleMessage.MessageLevel.ERROR) {
            this.presenter.onErrorDetected(ChatWindowErrorType.Console, -1, consoleMessage.message());
        }
        return super.onConsoleMessage(consoleMessage);
    }
}

