/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebStorage;
import androidx.annotation.NonNull;
import com.livechatinc.inappchat.ChatWindowView;
import com.livechatinc.inappchat.ChatWindowViewImpl;
import com.livechatinc.inappchat.R;

public class ChatWindowUtils {
    public static ChatWindowView createAndAttachChatWindowInstance(@NonNull Activity activity) {
        ViewGroup contentView = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        ChatWindowViewImpl chatWindowView = (ChatWindowViewImpl)LayoutInflater.from((Context)activity).inflate(R.layout.view_chat_window, contentView, false);
        contentView.addView((View)chatWindowView, -1, -1);
        return chatWindowView;
    }

    public static void detachChatWindowInstance(@NonNull Activity activity, @NonNull View view) {
        ViewGroup contentView = (ViewGroup)activity.getWindow().getDecorView().findViewById(0x1020002);
        contentView.removeView(view);
    }

    public static void clearSession(Context context) {
        WebStorage.getInstance().deleteAllData();
        if (Build.VERSION.SDK_INT >= 22) {
            CookieManager.getInstance().removeAllCookies(null);
            CookieManager.getInstance().flush();
        } else {
            CookieSyncManager cookieSyncMngr = CookieSyncManager.createInstance((Context)context);
            cookieSyncMngr.startSync();
            CookieManager cookieManager = CookieManager.getInstance();
            cookieManager.removeAllCookie();
            cookieManager.removeSessionCookie();
            cookieSyncMngr.stopSync();
            cookieSyncMngr.sync();
        }
    }
}

