/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.livechatinc.inappchat.LoadWebViewContentTask;
import com.livechatinc.inappchat.UriUtils;
import java.io.File;

public final class ChatWindowFragment
extends Fragment {
    private static final String KEY_LICENCE_NUMBER = "KEY_LICENCE_NUMBER_FRAGMENT";
    private static final String KEY_GROUP_ID = "KEY_GROUP_ID_FRAGMENT";
    private static final String KEY_VISITOR_NAME = "KEY_VISITOR_NAME_FRAGMENT";
    private static final String KEY_VISITOR_EMAIL = "KEY_VISITOR_EMAIL_FRAGMENT";
    private static final String DEFAULT_LICENCE_NUMBER = "-1";
    private static final String DEFAULT_GROUP_ID = "-1";
    private static final int REQUEST_CODE_FILE_UPLOAD = 21354;
    private ProgressBar mProgressBar;
    private WebView mWebView;
    private WebView mWebviewPopup;
    private Context mContext;
    private FrameLayout mContainer;
    private TextView mTextView;
    private ValueCallback<Uri> mUriUploadCallback;
    private ValueCallback<Uri[]> mUriArrayUploadCallback;
    private String mLicenceNumber = "-1";
    private String mGroupId = "-1";
    private String mVisitorName;
    private String mVisitorEmail;

    public static ChatWindowFragment newInstance(Object licenceNumber, Object groupId) {
        Bundle arguments = new Bundle();
        arguments.putString(KEY_LICENCE_NUMBER, String.valueOf(licenceNumber));
        arguments.putString(KEY_GROUP_ID, String.valueOf(groupId));
        ChatWindowFragment chatWindowFragment = new ChatWindowFragment();
        chatWindowFragment.setArguments(arguments);
        return chatWindowFragment;
    }

    public static ChatWindowFragment newInstance(Object licenceNumber, Object groupId, String visitorName, String visitorEmail) {
        Bundle arguments = new Bundle();
        arguments.putString(KEY_LICENCE_NUMBER, String.valueOf(licenceNumber));
        arguments.putString(KEY_GROUP_ID, String.valueOf(groupId));
        arguments.putString(KEY_VISITOR_NAME, visitorName);
        arguments.putString(KEY_VISITOR_EMAIL, visitorEmail);
        ChatWindowFragment chatWindowFragment = new ChatWindowFragment();
        chatWindowFragment.setArguments(arguments);
        return chatWindowFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mLicenceNumber = this.getArguments().getString(KEY_LICENCE_NUMBER);
            this.mGroupId = this.getArguments().getString(KEY_GROUP_ID);
            this.mVisitorName = this.getArguments().getString(KEY_VISITOR_NAME);
            this.mVisitorEmail = this.getArguments().getString(KEY_VISITOR_EMAIL);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.mContainer = new FrameLayout((Context)this.getActivity());
        this.mWebView = new WebView((Context)this.getActivity());
        if (Build.VERSION.RELEASE.matches("4\\.4(\\.[12])?")) {
            String userAgentString = this.mWebView.getSettings().getUserAgentString();
            this.mWebView.getSettings().setUserAgentString(userAgentString + " AndroidNoFilesharing");
        }
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        this.mWebView.setFocusable(true);
        WebSettings webSettings = this.mWebView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setAppCacheEnabled(true);
        webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
        webSettings.setSupportMultipleWindows(true);
        if (Build.VERSION.SDK_INT >= 21) {
            cookieManager.getInstance().setAcceptThirdPartyCookies(this.mWebView, true);
        }
        this.mWebView.setWebViewClient((WebViewClient)new LCWebViewClient());
        this.mWebView.setWebChromeClient((WebChromeClient)new LCWebChromeClient());
        this.mWebView.requestFocus(130);
        this.mWebView.setVisibility(8);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: 
                    case 1: {
                        if (v.hasFocus()) break;
                        v.requestFocus();
                    }
                }
                return false;
            }
        });
        this.mProgressBar = new ProgressBar((Context)this.getActivity());
        this.mProgressBar.setVisibility(8);
        this.mTextView = new TextView((Context)this.getActivity());
        this.mTextView.setGravity(17);
        this.mTextView.setText((CharSequence)"Couldn't load chat.");
        this.mTextView.setVisibility(8);
        this.mContainer.addView((View)this.mWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mContainer.addView((View)this.mProgressBar, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.mContainer.addView((View)this.mTextView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        return this.mContainer;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mContext = this.getActivity().getApplicationContext();
        new LoadWebViewContentTask(this.mWebView, this.mProgressBar, this.mTextView).execute(new String[]{this.mLicenceNumber, this.mGroupId, this.mVisitorName, this.mVisitorEmail});
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 21354) {
            if (resultCode == -1 && data != null) {
                this.receiveUploadedData(data);
            } else {
                this.resetAllUploadCallbacks();
            }
        }
    }

    private void receiveUploadedData(Intent data) {
        if (this.isUriArrayUpload()) {
            this.receiveUploadedUriArray(data);
        } else if (this.isVersionPreHoneycomb()) {
            this.receiveUploadedUriPreHoneycomb(data);
        } else {
            this.receiveUploadedUri(data);
        }
    }

    private boolean isUriArrayUpload() {
        return this.mUriArrayUploadCallback != null;
    }

    private boolean isVersionPreHoneycomb() {
        return Build.VERSION.SDK_INT < 11;
    }

    private void receiveUploadedUriArray(Intent data) {
        Uri[] uploadedUris;
        try {
            uploadedUris = new Uri[]{Uri.parse((String)data.getDataString())};
        }
        catch (Exception e) {
            uploadedUris = null;
        }
        this.mUriArrayUploadCallback.onReceiveValue(uploadedUris);
        this.mUriArrayUploadCallback = null;
    }

    private void receiveUploadedUriPreHoneycomb(Intent data) {
        Uri uploadedUri = data.getData();
        this.mUriUploadCallback.onReceiveValue((Object)uploadedUri);
        this.mUriUploadCallback = null;
    }

    private void receiveUploadedUri(Intent data) {
        Uri uploadedFileUri;
        try {
            String uploadedUriFilePath = UriUtils.getFilePathFromUri((Context)this.getActivity(), data.getData());
            File uploadedFile = new File(uploadedUriFilePath);
            uploadedFileUri = Uri.fromFile((File)uploadedFile);
        }
        catch (Exception e) {
            uploadedFileUri = null;
        }
        this.mUriUploadCallback.onReceiveValue(uploadedFileUri);
        this.mUriUploadCallback = null;
    }

    private void chooseUriToUpload(ValueCallback<Uri> uriValueCallback) {
        this.resetAllUploadCallbacks();
        this.mUriUploadCallback = uriValueCallback;
        this.startFileChooserActivity();
    }

    private void chooseUriArrayToUpload(ValueCallback<Uri[]> uriArrayValueCallback) {
        this.resetAllUploadCallbacks();
        this.mUriArrayUploadCallback = uriArrayValueCallback;
        this.startFileChooserActivity();
    }

    private void startFileChooserActivity() {
        try {
            Intent intent = new Intent("android.intent.action.GET_CONTENT");
            intent.addCategory("android.intent.category.OPENABLE");
            intent.setType("*/*");
            this.startActivityForResult(Intent.createChooser((Intent)intent, (CharSequence)"Choose file to upload"), 21354);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            // empty catch block
        }
    }

    private void resetAllUploadCallbacks() {
        this.resetUriUploadCallback();
        this.resetUriArrayUploadCallback();
    }

    private void resetUriUploadCallback() {
        if (this.mUriUploadCallback != null) {
            this.mUriUploadCallback.onReceiveValue(null);
            this.mUriUploadCallback = null;
        }
    }

    private void resetUriArrayUploadCallback() {
        if (this.mUriArrayUploadCallback != null) {
            this.mUriArrayUploadCallback.onReceiveValue(null);
            this.mUriArrayUploadCallback = null;
        }
    }

    class LCWebChromeClient
    extends WebChromeClient {
        LCWebChromeClient() {
        }

        public boolean onCreateWindow(WebView view, boolean isDialog, boolean isUserGesture, Message resultMsg) {
            ChatWindowFragment.this.mWebviewPopup = new WebView(ChatWindowFragment.this.mContext);
            CookieManager cookieManager = CookieManager.getInstance();
            if (Build.VERSION.SDK_INT >= 21) {
                cookieManager.getInstance().setAcceptThirdPartyCookies(ChatWindowFragment.this.mWebviewPopup, true);
            }
            ChatWindowFragment.this.mWebviewPopup.setVerticalScrollBarEnabled(false);
            ChatWindowFragment.this.mWebviewPopup.setHorizontalScrollBarEnabled(false);
            ChatWindowFragment.this.mWebviewPopup.setWebViewClient((WebViewClient)new LCWebViewClient());
            ChatWindowFragment.this.mWebviewPopup.getSettings().setJavaScriptEnabled(true);
            ChatWindowFragment.this.mWebviewPopup.getSettings().setSavePassword(false);
            ChatWindowFragment.this.mWebviewPopup.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            ChatWindowFragment.this.mContainer.addView((View)ChatWindowFragment.this.mWebviewPopup);
            WebView.WebViewTransport transport = (WebView.WebViewTransport)resultMsg.obj;
            transport.setWebView(ChatWindowFragment.this.mWebviewPopup);
            resultMsg.sendToTarget();
            return true;
        }

        public void onCloseWindow(WebView window) {
            Log.d((String)"onCloseWindow", (String)"called");
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg) {
            ChatWindowFragment.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
            ChatWindowFragment.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
            ChatWindowFragment.this.chooseUriToUpload((ValueCallback<Uri>)uploadMsg);
        }

        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> uploadMsg, WebChromeClient.FileChooserParams fileChooserParams) {
            ChatWindowFragment.this.chooseUriArrayToUpload((ValueCallback<Uri[]>)uploadMsg);
            return true;
        }
    }

    class LCWebViewClient
    extends WebViewClient {
        LCWebViewClient() {
        }

        public void onPageFinished(WebView view, String url) {
            ChatWindowFragment.this.mProgressBar.post(new Runnable(){

                @Override
                public void run() {
                    ChatWindowFragment.this.mProgressBar.setVisibility(8);
                }
            });
            if (url.startsWith("https://www.facebook.com/dialog/return/arbiter") && ChatWindowFragment.this.mWebviewPopup != null) {
                ChatWindowFragment.this.mWebviewPopup.setVisibility(8);
                ChatWindowFragment.this.mContainer.removeView((View)ChatWindowFragment.this.mWebviewPopup);
                ChatWindowFragment.this.mWebviewPopup = null;
            }
            super.onPageFinished(view, url);
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            ChatWindowFragment.this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChatWindowFragment.this.mProgressBar.setVisibility(8);
                    ChatWindowFragment.this.mWebView.setVisibility(8);
                    ChatWindowFragment.this.mTextView.setVisibility(0);
                }
            });
            super.onReceivedError(view, request, error);
            Log.e((String)"LiveChat Widget", (String)("onReceivedError: " + error + " request: " + request));
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            ChatWindowFragment.this.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ChatWindowFragment.this.mProgressBar.setVisibility(8);
                    ChatWindowFragment.this.mWebView.setVisibility(8);
                    ChatWindowFragment.this.mTextView.setVisibility(0);
                }
            });
            super.onReceivedError(view, errorCode, description, failingUrl);
            Log.e((String)"LiveChat Widget", (String)("onReceivedError: " + errorCode + " d: " + description + " url: " + failingUrl));
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Uri uri = Uri.parse((String)url);
            return this.handleUri(view, uri);
        }

        @TargetApi(value=24)
        public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
            Uri uri = request.getUrl();
            return this.handleUri(view, uri);
        }

        private boolean handleUri(WebView webView, Uri uri) {
            String originalUrl;
            String uriString = uri.toString();
            boolean facebookLogin = uriString.matches("https://.+facebook.+(/dialog/oauth\\?|/login\\.php\\?|/dialog/return/arbiter\\?).+");
            if (facebookLogin) {
                return false;
            }
            if (ChatWindowFragment.this.mWebviewPopup != null) {
                ChatWindowFragment.this.mWebviewPopup.setVisibility(8);
                ChatWindowFragment.this.mContainer.removeView((View)ChatWindowFragment.this.mWebviewPopup);
                ChatWindowFragment.this.mWebviewPopup = null;
            }
            if (uriString.equals(originalUrl = ChatWindowFragment.this.mWebView.getOriginalUrl())) {
                return false;
            }
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            ChatWindowFragment.this.startActivity(intent);
            return true;
        }
    }
}

