/*
 * Decompiled with CFR 0.152.
 */
package com.livechatinc.inappchat;

import android.util.Log;
import android.webkit.JavascriptInterface;
import com.google.gson.GsonBuilder;
import com.livechatinc.inappchat.ChatWindowViewImpl;
import com.livechatinc.inappchat.models.NewMessageModel;
import org.json.JSONException;
import org.json.JSONObject;

class ChatWindowJsInterface {
    private final ChatWindowViewImpl view;
    public static final String BRIDGE_OBJECT_NAME = "androidMobileWidget";
    private static final String KEY_MESSAGE_TYPE = "messageType";
    private static final String TYPE_UI_READY = "uiReady";
    private static final String TYPE_HIDE_CHAT_WINDOW = "hideChatWindow";
    private static final String TYPE_NEW_MESSAGE = "newMessage";

    public ChatWindowJsInterface(ChatWindowViewImpl view) {
        this.view = view;
    }

    @JavascriptInterface
    public void postMessage(String messageJson) {
        Log.i((String)"Interface", (String)("postMessage: " + messageJson));
        try {
            JSONObject jsonObject = new JSONObject(messageJson);
            if (jsonObject != null && jsonObject.has(KEY_MESSAGE_TYPE)) {
                this.dispatchMessage(jsonObject.getString(KEY_MESSAGE_TYPE), messageJson);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void dispatchMessage(String messageType, String json) {
        switch (messageType) {
            case "hideChatWindow": {
                this.view.onHideChatWindow();
                break;
            }
            case "uiReady": {
                this.view.onUiReady();
                break;
            }
            case "newMessage": {
                this.view.onNewMessageReceived((NewMessageModel)new GsonBuilder().create().fromJson(json, NewMessageModel.class));
            }
        }
    }
}

