/*
 * Decompiled with CFR 0.152.
 */
package com.spider.autoswitching;

import com.spider.autoswitching.AsyncTerminateStrategy;
import com.spider.autoswitching.Createable;
import com.spider.proxy.AutosWitchingProxyHandler;
import com.spider.spring.SpringContextHolder;
import java.util.Set;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationEvent;

public interface AutoSwitchingBean<T> {
    public String beanName();

    public Class<T> type();

    public String monitorSourcePrefix();

    public AsyncTerminateStrategy<T> asyncTerminateStrategy();

    public Createable<T> supplier();

    public AutosWitchingProxyHandler<T> autosWitchingProxyHandler();

    default public String namespace() {
        return "application";
    }

    default public <V> void onChange(Set<String> changedKeys, V changeEvent) {
        for (String changedKey : changedKeys) {
            if (!changedKey.startsWith(this.monitorSourcePrefix())) continue;
            SpringContextHolder.applicationContext().publishEvent((ApplicationEvent)new EnvironmentChangeEvent(changedKeys));
            this.asyncTerminateStrategy().terminate(this.autosWitchingProxyHandler().replace(this.supplier().create()));
            return;
        }
    }
}

