/*
 * Decompiled with CFR 0.152.
 */
package com.rxjava.rxlife;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.rxjava.rxlife.Scope;
import io.reactivex.rxjava3.disposables.Disposable;
import org.jetbrains.annotations.NotNull;

public final class LifecycleScope
implements Scope,
LifecycleEventObserver {
    private final Lifecycle lifecycle;
    private final Lifecycle.Event event;
    private Disposable disposable;

    private LifecycleScope(Lifecycle lifecycle, Lifecycle.Event event) {
        this.lifecycle = lifecycle;
        this.event = event;
    }

    static LifecycleScope from(LifecycleOwner owner, Lifecycle.Event event) {
        return new LifecycleScope(owner.getLifecycle(), event);
    }

    @Override
    public void onScopeStart(Disposable d) {
        this.disposable = d;
        this.onScopeEnd();
        Lifecycle lifecycle = this.lifecycle;
        if (lifecycle == null) {
            throw new NullPointerException("lifecycle is null");
        }
        lifecycle.addObserver((LifecycleObserver)this);
    }

    @Override
    public void onScopeEnd() {
        Lifecycle lifecycle = this.lifecycle;
        if (lifecycle == null) {
            throw new NullPointerException("lifecycle is null");
        }
        lifecycle.removeObserver((LifecycleObserver)this);
    }

    public void onStateChanged(@NotNull LifecycleOwner source, Lifecycle.Event event) {
        if (event.equals((Object)this.event)) {
            this.disposable.dispose();
            source.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }
}

