package com.rxhttp.compiler

/**
 * RxJava 版本管理
 * User: ljx
 * Date: 2020/4/12
 * Time: 15:33
 */
private var rxJavaVersion: String? = null

private val rxJavaClassList = LinkedHashMap<String, String>()

fun getClassPath(simpleName: String): String = rxJavaClassList[simpleName] + ".$simpleName"

fun isDependenceRxJava() = rxJavaVersion != null

fun initRxJavaVersion(version: String?) {
    val realVersion = when {
        version.equals("RxJava2", true) -> "2.0.0"
        version.equals("RxJava3", true) -> "3.0.0"
        else -> version
    } ?: return
    rxJavaVersion = realVersion
    if (realVersion.versionCompare("3.0.0") >= 0) {
        rxJavaClassList["Scheduler"] = "io.reactivex.rxjava3.core"
        rxJavaClassList["Observable"] = "io.reactivex.rxjava3.core"
        rxJavaClassList["Consumer"] = "io.reactivex.rxjava3.functions"
        rxJavaClassList["Schedulers"] = "io.reactivex.rxjava3.schedulers"
        rxJavaClassList["RxJavaPlugins"] = "io.reactivex.rxjava3.plugins"
        rxJavaClassList["Observer"] = "io.reactivex.rxjava3.core"
        rxJavaClassList["Exceptions"] = "io.reactivex.rxjava3.exceptions"
        rxJavaClassList["Disposable"] = "io.reactivex.rxjava3.disposables"
        rxJavaClassList["DisposableHelper"] = "io.reactivex.rxjava3.internal.disposables"
        rxJavaClassList["Disposable"] = "io.reactivex.rxjava3.disposables"
        rxJavaClassList["ObservableSource"] = "io.reactivex.rxjava3.core"
        rxJavaClassList["TrampolineScheduler"] = "io.reactivex.rxjava3.internal.schedulers"
        rxJavaClassList["AndroidSchedulers"] = "io.reactivex.rxjava3.android.schedulers"
    } else {
        rxJavaClassList["Scheduler"] = "io.reactivex"
        rxJavaClassList["Observable"] = "io.reactivex"
        rxJavaClassList["Consumer"] = "io.reactivex.functions"
        rxJavaClassList["Schedulers"] = "io.reactivex.schedulers"
        rxJavaClassList["RxJavaPlugins"] = "io.reactivex.plugins"
        rxJavaClassList["Observer"] = "io.reactivex"
        rxJavaClassList["Exceptions"] = "io.reactivex.exceptions"
        rxJavaClassList["Disposable"] = "io.reactivex.disposables"
        rxJavaClassList["DisposableHelper"] = "io.reactivex.internal.disposables"
        rxJavaClassList["Disposable"] = "io.reactivex.disposables"
        rxJavaClassList["ObservableSource"] = "io.reactivex"
        rxJavaClassList["TrampolineScheduler"] = "io.reactivex.internal.schedulers"
        rxJavaClassList["AndroidSchedulers"] = "io.reactivex.android.schedulers"
    }
}

private fun String.versionCompare(version: String): Int {
    val versionArr1 = split(".")
    val versionArr2 = version.split(".")
    val minLen = versionArr1.size.coerceAtMost(versionArr2.size)
    var diff = 0
    for (i in 0 until minLen) {
        val v1 = versionArr1[i]
        val v2 = versionArr2[i]
        diff = v1.length - v2.length
        if (diff == 0) {
            diff = v1.compareTo(v2)
        }
        if (diff != 0) {
            break
        }
    }
    return if (diff != 0) diff else versionArr1.size - versionArr2.size
}