/*
 * Decompiled with CFR 0.152.
 */
package skin.support.design.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.StyleRes;
import com.google.android.material.textfield.TextInputLayout;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import skin.support.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.design.R;
import skin.support.design.widget.SkinMaterialTextInputEditText;
import skin.support.widget.SkinCompatBackgroundHelper;
import skin.support.widget.SkinCompatEditText;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinMaterialTextInputLayout
extends TextInputLayout
implements SkinCompatSupportable {
    private SkinCompatBackgroundHelper mBackgroundTintHelper = new SkinCompatBackgroundHelper((View)this);
    private int mPasswordToggleResId = 0;
    private int mCounterTextColorResId = 0;
    private int mErrorTextColorResId = 0;
    private int mFocusedTextColorResId = 0;
    private int mDefaultTextColorResId = 0;

    public SkinMaterialTextInputLayout(Context context) {
        this(context, null);
    }

    public SkinMaterialTextInputLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinMaterialTextInputLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mBackgroundTintHelper.loadFromAttributes(attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TextInputLayout, defStyleAttr, R.style.Widget_Design_TextInputLayout);
        if (a.hasValue(R.styleable.TextInputLayout_android_textColorHint)) {
            this.mDefaultTextColorResId = this.mFocusedTextColorResId = a.getResourceId(R.styleable.TextInputLayout_android_textColorHint, 0);
            this.applyFocusedTextColorResource();
        }
        int errorTextAppearance = a.getResourceId(R.styleable.TextInputLayout_errorTextAppearance, 0);
        this.loadErrorTextColorResFromAttributes(errorTextAppearance);
        int counterTextAppearance = a.getResourceId(R.styleable.TextInputLayout_counterTextAppearance, 0);
        this.loadCounterTextColorResFromAttributes(counterTextAppearance);
        this.mPasswordToggleResId = a.getResourceId(R.styleable.TextInputLayout_passwordToggleDrawable, 0);
        a.recycle();
    }

    private void loadCounterTextColorResFromAttributes(@StyleRes int resId) {
        if (resId != 0) {
            TypedArray counterTA = this.getContext().obtainStyledAttributes(resId, R.styleable.SkinTextAppearance);
            if (counterTA.hasValue(R.styleable.SkinTextAppearance_android_textColor)) {
                this.mCounterTextColorResId = counterTA.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
            }
            counterTA.recycle();
        }
        this.applyCounterTextColorResource();
    }

    public void setCounterEnabled(boolean enabled) {
        super.setCounterEnabled(enabled);
        if (enabled) {
            this.applyCounterTextColorResource();
        }
    }

    private void applyCounterTextColorResource() {
        TextView counterView;
        this.mCounterTextColorResId = SkinCompatHelper.checkResourceId((int)this.mCounterTextColorResId);
        if (this.mCounterTextColorResId != 0 && (counterView = this.getCounterView()) != null) {
            counterView.setTextColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mCounterTextColorResId));
            this.updateEditTextBackgroundInternal();
        }
    }

    private TextView getCounterView() {
        try {
            Field counterView = TextInputLayout.class.getDeclaredField("mCounterView");
            counterView.setAccessible(true);
            return (TextView)counterView.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setErrorTextAppearance(@StyleRes int resId) {
        super.setErrorTextAppearance(resId);
        this.loadErrorTextColorResFromAttributes(resId);
    }

    private void loadErrorTextColorResFromAttributes(@StyleRes int resId) {
        if (resId != 0) {
            TypedArray errorTA = this.getContext().obtainStyledAttributes(resId, R.styleable.SkinTextAppearance);
            if (errorTA.hasValue(R.styleable.SkinTextAppearance_android_textColor)) {
                this.mErrorTextColorResId = errorTA.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
            }
            errorTA.recycle();
        }
        this.applyErrorTextColorResource();
    }

    public void setErrorEnabled(boolean enabled) {
        super.setErrorEnabled(enabled);
        if (enabled) {
            this.applyErrorTextColorResource();
        }
    }

    private void applyErrorTextColorResource() {
        TextView errorView;
        this.mErrorTextColorResId = SkinCompatHelper.checkResourceId((int)this.mErrorTextColorResId);
        if (this.mErrorTextColorResId != 0 && this.mErrorTextColorResId != R.color.design_error && (errorView = this.getErrorView()) != null) {
            errorView.setTextColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mErrorTextColorResId));
            this.updateEditTextBackgroundInternal();
        }
    }

    private TextView getErrorView() {
        try {
            Field errorView = TextInputLayout.class.getDeclaredField("mErrorView");
            errorView.setAccessible(true);
            return (TextView)errorView.get((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateEditTextBackgroundInternal() {
        try {
            Method updateEditTextBackground = TextInputLayout.class.getDeclaredMethod("updateEditTextBackground", new Class[0]);
            updateEditTextBackground.setAccessible(true);
            updateEditTextBackground.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDefaultTextColor(ColorStateList colors) {
        try {
            Field defaultTextColor = TextInputLayout.class.getDeclaredField("mDefaultTextColor");
            defaultTextColor.setAccessible(true);
            defaultTextColor.set((Object)this, colors);
            this.updateLabelState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void applyFocusedTextColorResource() {
        this.mFocusedTextColorResId = SkinCompatHelper.checkResourceId((int)this.mFocusedTextColorResId);
        if (this.mFocusedTextColorResId != 0 && this.mFocusedTextColorResId != R.color.abc_hint_foreground_material_light) {
            this.setFocusedTextColor(SkinCompatResources.getColorStateList((Context)this.getContext(), (int)this.mFocusedTextColorResId));
        } else if (this.getEditText() != null) {
            int textColorResId = 0;
            if (this.getEditText() instanceof SkinCompatEditText) {
                textColorResId = ((SkinCompatEditText)this.getEditText()).getTextColorResId();
            } else if (this.getEditText() instanceof SkinMaterialTextInputEditText) {
                textColorResId = ((SkinMaterialTextInputEditText)this.getEditText()).getTextColorResId();
            }
            textColorResId = SkinCompatHelper.checkResourceId((int)textColorResId);
            if (textColorResId != 0) {
                ColorStateList colors = SkinCompatResources.getColorStateList((Context)this.getContext(), (int)textColorResId);
                this.setFocusedTextColor(colors);
            }
        }
    }

    private void setFocusedTextColor(ColorStateList colors) {
        try {
            Field focusedTextColor = TextInputLayout.class.getDeclaredField("mFocusedTextColor");
            focusedTextColor.setAccessible(true);
            focusedTextColor.set((Object)this, colors);
            this.updateLabelState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateLabelState() {
        try {
            Method updateLabelState = TextInputLayout.class.getDeclaredMethod("updateLabelState", Boolean.TYPE);
            updateLabelState.setAccessible(true);
            updateLabelState.invoke((Object)this, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void applySkin() {
        this.applyErrorTextColorResource();
        this.applyCounterTextColorResource();
        this.applyFocusedTextColorResource();
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySkin();
        }
    }
}

