/*
 * Decompiled with CFR 0.152.
 */
package skin.support.design.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.google.android.material.tabs.TabLayout;
import skin.support.content.res.SkinCompatResources;
import skin.support.design.R;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinMaterialTabLayout
extends TabLayout
implements SkinCompatSupportable {
    private int mTabIndicatorColorResId = 0;
    private int mTabTextColorsResId = 0;
    private int mTabSelectedTextColorResId = 0;

    public SkinMaterialTabLayout(Context context) {
        this(context, null);
    }

    public SkinMaterialTabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SkinMaterialTabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabLayout, defStyleAttr, 0);
        this.mTabIndicatorColorResId = a.getResourceId(R.styleable.TabLayout_tabIndicatorColor, 0);
        int tabTextAppearance = a.getResourceId(R.styleable.TabLayout_tabTextAppearance, R.style.TextAppearance_Design_Tab);
        TypedArray ta = context.obtainStyledAttributes(tabTextAppearance, R.styleable.SkinTextAppearance);
        try {
            this.mTabTextColorsResId = ta.getResourceId(R.styleable.SkinTextAppearance_android_textColor, 0);
        }
        finally {
            ta.recycle();
        }
        if (a.hasValue(R.styleable.TabLayout_tabTextColor)) {
            this.mTabTextColorsResId = a.getResourceId(R.styleable.TabLayout_tabTextColor, 0);
        }
        if (a.hasValue(R.styleable.TabLayout_tabSelectedTextColor)) {
            this.mTabSelectedTextColorResId = a.getResourceId(R.styleable.TabLayout_tabSelectedTextColor, 0);
        }
        a.recycle();
        this.applySkin();
    }

    public void applySkin() {
        this.mTabIndicatorColorResId = SkinCompatHelper.checkResourceId((int)this.mTabIndicatorColorResId);
        if (this.mTabIndicatorColorResId != 0) {
            this.setSelectedTabIndicatorColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mTabIndicatorColorResId));
        }
        this.mTabTextColorsResId = SkinCompatHelper.checkResourceId((int)this.mTabTextColorsResId);
        if (this.mTabTextColorsResId != 0) {
            this.setTabTextColors(SkinCompatResources.getColorStateList((Context)this.getContext(), (int)this.mTabTextColorsResId));
        }
        this.mTabSelectedTextColorResId = SkinCompatHelper.checkResourceId((int)this.mTabSelectedTextColorResId);
        if (this.mTabSelectedTextColorResId != 0) {
            int selected = SkinCompatResources.getColor((Context)this.getContext(), (int)this.mTabSelectedTextColorResId);
            if (this.getTabTextColors() != null) {
                this.setTabTextColors(this.getTabTextColors().getDefaultColor(), selected);
            }
        }
    }
}

