/*
 * Decompiled with CFR 0.152.
 */
package skin.support.design.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import skin.support.content.res.SkinCompatResources;
import skin.support.design.R;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatImageHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinMaterialFloatingActionButton
extends FloatingActionButton
implements SkinCompatSupportable {
    private int mRippleColorResId = 0;
    private int mBackgroundTintResId = 0;
    private SkinCompatImageHelper mImageHelper;

    public SkinMaterialFloatingActionButton(Context context) {
        this(context, null);
    }

    public SkinMaterialFloatingActionButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinMaterialFloatingActionButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FloatingActionButton, defStyleAttr, R.style.Widget_Design_FloatingActionButton);
        this.mBackgroundTintResId = a.getResourceId(R.styleable.FloatingActionButton_backgroundTint, 0);
        this.mRippleColorResId = a.getResourceId(R.styleable.FloatingActionButton_rippleColor, 0);
        a.recycle();
        this.applyBackgroundTintResource();
        this.applyRippleColorResource();
        this.mImageHelper = new SkinCompatImageHelper((ImageView)this);
        this.mImageHelper.loadFromAttributes(attrs, defStyleAttr);
    }

    private void applyBackgroundTintResource() {
        this.mBackgroundTintResId = SkinCompatHelper.checkResourceId((int)this.mBackgroundTintResId);
        if (this.mBackgroundTintResId != 0) {
            this.setBackgroundTintList(SkinCompatResources.getColorStateList((Context)this.getContext(), (int)this.mBackgroundTintResId));
        }
    }

    private void applyRippleColorResource() {
        this.mRippleColorResId = SkinCompatHelper.checkResourceId((int)this.mRippleColorResId);
        if (this.mRippleColorResId != 0) {
            this.setRippleColor(SkinCompatResources.getColor((Context)this.getContext(), (int)this.mRippleColorResId));
        }
    }

    public void applySkin() {
        this.applyBackgroundTintResource();
        this.applyRippleColorResource();
        if (this.mImageHelper != null) {
            this.mImageHelper.applySkin();
        }
    }
}

