/*
 * Decompiled with CFR 0.152.
 */
package skin.support.design.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.google.android.material.appbar.CollapsingToolbarLayout;
import skin.support.content.res.SkinCompatVectorResources;
import skin.support.design.R;
import skin.support.widget.SkinCompatBackgroundHelper;
import skin.support.widget.SkinCompatHelper;
import skin.support.widget.SkinCompatSupportable;

public class SkinMaterialCollapsingToolbarLayout
extends CollapsingToolbarLayout
implements SkinCompatSupportable {
    private int mContentScrimResId = 0;
    private int mStatusBarScrimResId = 0;
    private SkinCompatBackgroundHelper mBackgroundTintHelper;

    public SkinMaterialCollapsingToolbarLayout(Context context) {
        this(context, null);
    }

    public SkinMaterialCollapsingToolbarLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SkinMaterialCollapsingToolbarLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CollapsingToolbarLayout, defStyleAttr, R.style.Widget_Design_CollapsingToolbar);
        this.mContentScrimResId = a.getResourceId(R.styleable.CollapsingToolbarLayout_contentScrim, 0);
        this.mStatusBarScrimResId = a.getResourceId(R.styleable.CollapsingToolbarLayout_statusBarScrim, 0);
        a.recycle();
        this.applyContentScrimResource();
        this.applyStatusBarScrimResource();
        this.mBackgroundTintHelper = new SkinCompatBackgroundHelper((View)this);
        this.mBackgroundTintHelper.loadFromAttributes(attrs, 0);
    }

    private void applyStatusBarScrimResource() {
        Drawable drawable;
        this.mStatusBarScrimResId = SkinCompatHelper.checkResourceId((int)this.mStatusBarScrimResId);
        if (this.mStatusBarScrimResId != 0 && (drawable = SkinCompatVectorResources.getDrawableCompat((Context)this.getContext(), (int)this.mStatusBarScrimResId)) != null) {
            this.setStatusBarScrim(drawable);
        }
    }

    private void applyContentScrimResource() {
        Drawable drawable;
        this.mContentScrimResId = SkinCompatHelper.checkResourceId((int)this.mContentScrimResId);
        if (this.mContentScrimResId != 0 && (drawable = SkinCompatVectorResources.getDrawableCompat((Context)this.getContext(), (int)this.mContentScrimResId)) != null) {
            this.setContentScrim(drawable);
        }
    }

    public void applySkin() {
        this.applyContentScrimResource();
        this.applyStatusBarScrimResource();
        if (this.mBackgroundTintHelper != null) {
            this.mBackgroundTintHelper.applySkin();
        }
    }
}

