/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Shader;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ClipDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.ProgressBar;
import skin.support.appcompat.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.content.res.SkinCompatVectorResources;
import skin.support.utils.SkinCompatVersionUtils;
import skin.support.widget.SkinCompatHelper;

public class SkinCompatProgressBarHelper
extends SkinCompatHelper {
    private final ProgressBar mView;
    private Bitmap mSampleTile;
    private int mIndeterminateDrawableResId = 0;
    private int mProgressDrawableResId = 0;
    private int mIndeterminateTintResId = 0;

    SkinCompatProgressBarHelper(ProgressBar view) {
        this.mView = view;
    }

    void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.SkinCompatProgressBar, defStyleAttr, 0);
        this.mIndeterminateDrawableResId = a.getResourceId(R.styleable.SkinCompatProgressBar_android_indeterminateDrawable, 0);
        this.mProgressDrawableResId = a.getResourceId(R.styleable.SkinCompatProgressBar_android_progressDrawable, 0);
        a.recycle();
        if (Build.VERSION.SDK_INT > 21) {
            a = this.mView.getContext().obtainStyledAttributes(attrs, new int[]{16843881}, defStyleAttr, 0);
            this.mIndeterminateTintResId = a.getResourceId(0, 0);
            a.recycle();
        }
        this.applySkin();
    }

    private Drawable tileify(Drawable drawable2, boolean clip) {
        if (SkinCompatVersionUtils.isV4WrappedDrawable((Drawable)drawable2)) {
            Drawable inner = SkinCompatVersionUtils.getV4WrappedDrawableWrappedDrawable((Drawable)drawable2);
            if (inner != null) {
                inner = this.tileify(inner, clip);
                SkinCompatVersionUtils.setV4WrappedDrawableWrappedDrawable((Drawable)drawable2, (Drawable)inner);
            }
        } else if (SkinCompatVersionUtils.isV4DrawableWrapper((Drawable)drawable2)) {
            Drawable inner = SkinCompatVersionUtils.getV4DrawableWrapperWrappedDrawable((Drawable)drawable2);
            if (inner != null) {
                inner = this.tileify(inner, clip);
                SkinCompatVersionUtils.setV4DrawableWrapperWrappedDrawable((Drawable)drawable2, (Drawable)inner);
            }
        } else {
            if (drawable2 instanceof LayerDrawable) {
                LayerDrawable background = (LayerDrawable)drawable2;
                int N = background.getNumberOfLayers();
                Drawable[] outDrawables = new Drawable[N];
                for (int i = 0; i < N; ++i) {
                    int id2 = background.getId(i);
                    outDrawables[i] = this.tileify(background.getDrawable(i), id2 == 16908301 || id2 == 16908303);
                }
                LayerDrawable newBg = new LayerDrawable(outDrawables);
                for (int i = 0; i < N; ++i) {
                    newBg.setId(i, background.getId(i));
                }
                return newBg;
            }
            if (drawable2 instanceof BitmapDrawable) {
                BitmapDrawable bitmapDrawable = (BitmapDrawable)drawable2;
                Bitmap tileBitmap = bitmapDrawable.getBitmap();
                if (this.mSampleTile == null) {
                    this.mSampleTile = tileBitmap;
                }
                ShapeDrawable shapeDrawable = new ShapeDrawable(this.getDrawableShape());
                BitmapShader bitmapShader = new BitmapShader(tileBitmap, Shader.TileMode.REPEAT, Shader.TileMode.CLAMP);
                shapeDrawable.getPaint().setShader((Shader)bitmapShader);
                shapeDrawable.getPaint().setColorFilter(bitmapDrawable.getPaint().getColorFilter());
                return clip ? new ClipDrawable((Drawable)shapeDrawable, 3, 1) : shapeDrawable;
            }
        }
        return drawable2;
    }

    private Drawable tileifyIndeterminate(Drawable drawable2) {
        if (drawable2 instanceof AnimationDrawable) {
            AnimationDrawable background = (AnimationDrawable)drawable2;
            int N = background.getNumberOfFrames();
            AnimationDrawable newBg = new AnimationDrawable();
            newBg.setOneShot(background.isOneShot());
            for (int i = 0; i < N; ++i) {
                Drawable frame = this.tileify(background.getFrame(i), true);
                frame.setLevel(10000);
                newBg.addFrame(frame, background.getDuration(i));
            }
            newBg.setLevel(10000);
            drawable2 = newBg;
        }
        return drawable2;
    }

    private Shape getDrawableShape() {
        float[] roundedCorners = new float[]{5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f, 5.0f};
        return new RoundRectShape(roundedCorners, null, null);
    }

    public void applySkin() {
        Drawable drawable2;
        this.mIndeterminateDrawableResId = SkinCompatProgressBarHelper.checkResourceId((int)this.mIndeterminateDrawableResId);
        if (this.mIndeterminateDrawableResId != 0) {
            drawable2 = SkinCompatVectorResources.getDrawableCompat(this.mView.getContext(), this.mIndeterminateDrawableResId);
            drawable2.setBounds(this.mView.getIndeterminateDrawable().getBounds());
            this.mView.setIndeterminateDrawable(this.tileifyIndeterminate(drawable2));
        }
        this.mProgressDrawableResId = this.checkProgressDrawableResId(this.mProgressDrawableResId);
        if (this.mProgressDrawableResId != 0) {
            drawable2 = SkinCompatVectorResources.getDrawableCompat(this.mView.getContext(), this.mProgressDrawableResId);
            this.mView.setProgressDrawable(this.tileify(drawable2, false));
        }
        if (Build.VERSION.SDK_INT > 21) {
            this.mIndeterminateTintResId = SkinCompatProgressBarHelper.checkResourceId((int)this.mIndeterminateTintResId);
            if (this.mIndeterminateTintResId != 0) {
                this.mView.setIndeterminateTintList(SkinCompatResources.getColorStateList((Context)this.mView.getContext(), (int)this.mIndeterminateTintResId));
            }
        }
    }

    private int checkProgressDrawableResId(int mProgressDrawableResId) {
        return SkinCompatProgressBarHelper.checkResourceId((int)mProgressDrawableResId);
    }
}

