/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.core.widget.ImageViewCompat;
import skin.support.R;
import skin.support.content.res.SkinCompatResources;
import skin.support.content.res.SkinCompatVectorResources;
import skin.support.widget.SkinCompatHelper;

public class SkinCompatImageHelper
extends SkinCompatHelper {
    private static final String TAG = SkinCompatImageHelper.class.getSimpleName();
    private final ImageView mView;
    private int mSrcResId = 0;
    private int mSrcCompatResId = 0;
    private int mSrcTintResId = 0;

    public SkinCompatImageHelper(ImageView imageView) {
        this.mView = imageView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = null;
        try {
            a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.SkinCompatImageView, defStyleAttr, 0);
            this.mSrcResId = a.getResourceId(R.styleable.SkinCompatImageView_android_src, 0);
            this.mSrcCompatResId = a.getResourceId(R.styleable.SkinCompatImageView_srcCompat, 0);
            this.mSrcTintResId = a.getResourceId(R.styleable.SkinCompatImageView_tint, 0);
            if (this.mSrcTintResId == 0) {
                this.mSrcTintResId = a.getResourceId(R.styleable.SkinCompatImageView_android_tint, 0);
            }
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        this.applySkin();
    }

    public void setImageResource(int resId) {
        this.mSrcResId = resId;
        this.mSrcCompatResId = 0;
        this.applySkin();
    }

    public void applySkin() {
        Drawable drawable2;
        this.mSrcCompatResId = SkinCompatImageHelper.checkResourceId((int)this.mSrcCompatResId);
        if (this.mSrcCompatResId != 0) {
            drawable2 = SkinCompatVectorResources.getDrawableCompat(this.mView.getContext(), this.mSrcCompatResId);
            if (drawable2 != null) {
                this.mView.setImageDrawable(drawable2);
            }
        } else {
            this.mSrcResId = SkinCompatImageHelper.checkResourceId((int)this.mSrcResId);
            if (this.mSrcResId != 0 && (drawable2 = SkinCompatVectorResources.getDrawableCompat(this.mView.getContext(), this.mSrcResId)) != null) {
                this.mView.setImageDrawable(drawable2);
            }
        }
        this.mSrcTintResId = SkinCompatImageHelper.checkResourceId((int)this.mSrcTintResId);
        if (this.mSrcTintResId != 0) {
            ColorStateList tintList = SkinCompatResources.getColorStateList((Context)this.mView.getContext(), (int)this.mSrcTintResId);
            ImageViewCompat.setImageTintList((ImageView)this.mView, (ColorStateList)tintList);
        }
    }
}

