/*
 * Decompiled with CFR 0.152.
 */
package skin.support.widget;

import android.content.res.TypedArray;
import android.graphics.ColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.view.ViewCompat;
import skin.support.R;
import skin.support.content.res.SkinCompatVectorResources;
import skin.support.widget.SkinCompatHelper;

public class SkinCompatBackgroundHelper
extends SkinCompatHelper {
    private final View mView;
    private int mBackgroundResId = 0;

    public SkinCompatBackgroundHelper(View view) {
        this.mView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromAttributes(AttributeSet attrs, int defStyleAttr) {
        TypedArray a = this.mView.getContext().obtainStyledAttributes(attrs, R.styleable.SkinBackgroundHelper, defStyleAttr, 0);
        try {
            if (a.hasValue(R.styleable.SkinBackgroundHelper_android_background)) {
                this.mBackgroundResId = a.getResourceId(R.styleable.SkinBackgroundHelper_android_background, 0);
            }
        }
        finally {
            a.recycle();
        }
        this.applySkin();
    }

    public void onSetBackgroundResource(int resId) {
        this.mBackgroundResId = resId;
        this.applySkin();
    }

    public void applySkin() {
        Drawable drawable2;
        this.mBackgroundResId = SkinCompatBackgroundHelper.checkResourceId((int)this.mBackgroundResId);
        if (this.mBackgroundResId == 0) {
            return;
        }
        ColorFilter filter = null;
        if (Build.VERSION.SDK_INT >= 21 && this.mView.getBackground() != null) {
            filter = this.mView.getBackground().getColorFilter();
        }
        if ((drawable2 = SkinCompatVectorResources.getDrawableCompat(this.mView.getContext(), this.mBackgroundResId)) != null) {
            int paddingLeft = this.mView.getPaddingLeft();
            int paddingTop = this.mView.getPaddingTop();
            int paddingRight = this.mView.getPaddingRight();
            int paddingBottom = this.mView.getPaddingBottom();
            ViewCompat.setBackground((View)this.mView, (Drawable)drawable2);
            this.mView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        }
        if (filter != null) {
            this.mView.getBackground().setColorFilter(filter);
        }
    }
}

