/*
 * Decompiled with CFR 0.152.
 */
package skin.support.content.res;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.appcompat.content.res.AppCompatResources;
import skin.support.content.res.SkinCompatDrawableManager;
import skin.support.content.res.SkinCompatResources;
import skin.support.content.res.SkinCompatUserThemeManager;
import skin.support.content.res.SkinResources;

public class SkinCompatVectorResources
implements SkinResources {
    private static SkinCompatVectorResources sInstance;

    private SkinCompatVectorResources() {
        SkinCompatResources.getInstance().addSkinResources((SkinResources)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SkinCompatVectorResources getInstance() {
        if (sInstance != null) return sInstance;
        Class<SkinCompatVectorResources> clazz = SkinCompatVectorResources.class;
        synchronized (SkinCompatVectorResources.class) {
            if (sInstance != null) return sInstance;
            sInstance = new SkinCompatVectorResources();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void clear() {
        SkinCompatDrawableManager.get().clearCaches();
    }

    private Drawable getSkinDrawableCompat(Context context, int resId) {
        int targetResId;
        Drawable drawable2;
        ColorStateList colorStateList;
        if (AppCompatDelegate.isCompatVectorFromResourcesEnabled()) {
            Drawable drawable3;
            ColorStateList colorStateList2;
            if (!SkinCompatResources.getInstance().isDefaultSkin()) {
                try {
                    return SkinCompatDrawableManager.get().getDrawable(context, resId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!SkinCompatUserThemeManager.get().isColorEmpty() && (colorStateList2 = SkinCompatUserThemeManager.get().getColorStateList(resId)) != null) {
                return new ColorDrawable(colorStateList2.getDefaultColor());
            }
            if (!SkinCompatUserThemeManager.get().isDrawableEmpty() && (drawable3 = SkinCompatUserThemeManager.get().getDrawable(resId)) != null) {
                return drawable3;
            }
            drawable3 = SkinCompatResources.getInstance().getStrategyDrawable(context, resId);
            if (drawable3 != null) {
                return drawable3;
            }
            return AppCompatResources.getDrawable((Context)context, (int)resId);
        }
        if (!SkinCompatUserThemeManager.get().isColorEmpty() && (colorStateList = SkinCompatUserThemeManager.get().getColorStateList(resId)) != null) {
            return new ColorDrawable(colorStateList.getDefaultColor());
        }
        if (!SkinCompatUserThemeManager.get().isDrawableEmpty() && (drawable2 = SkinCompatUserThemeManager.get().getDrawable(resId)) != null) {
            return drawable2;
        }
        drawable2 = SkinCompatResources.getInstance().getStrategyDrawable(context, resId);
        if (drawable2 != null) {
            return drawable2;
        }
        if (!SkinCompatResources.getInstance().isDefaultSkin() && (targetResId = SkinCompatResources.getInstance().getTargetResId(context, resId)) != 0) {
            return SkinCompatResources.getInstance().getSkinResources().getDrawable(targetResId);
        }
        return AppCompatResources.getDrawable((Context)context, (int)resId);
    }

    public static Drawable getDrawableCompat(Context context, int resId) {
        return SkinCompatVectorResources.getInstance().getSkinDrawableCompat(context, resId);
    }
}

