/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.lib.net.loader.model;

import com.levylin.lib.net.CacheStrategy;
import com.levylin.lib.net.LoadUtils;
import com.levylin.lib.net.listener.OnLoadListener;
import io.reactivex.disposables.Disposable;
import okhttp3.Request;
import retrofit2.Call;

public abstract class Model<T> {
    CacheStrategy<T> cacheStrategy;
    private boolean isManualRefresh = false;

    protected Model() {
        Call<T> call = this.getModelCall();
        Request request = call.request();
        this.cacheStrategy = this.getCacheStrategy(request);
    }

    public abstract boolean isEmpty();

    public abstract void setData(boolean var1, T var2);

    public boolean isManualRefresh() {
        return this.isManualRefresh;
    }

    public void setManualRefresh(boolean isManualRefresh) {
        this.isManualRefresh = isManualRefresh;
    }

    public void preRefresh() {
        this.cacheStrategy.reset();
        this.cacheStrategy.setIsReadCache(false);
    }

    public void preReLoad() {
        this.cacheStrategy.reset();
        this.cacheStrategy.setIsReadCache(false);
    }

    public final Disposable load(OnLoadListener<T> listener) {
        return LoadUtils.load(this.getModelCall(), this.cacheStrategy, listener);
    }

    protected abstract Call<T> getModelCall();

    protected CacheStrategy<T> getCacheStrategy(Request request) {
        return null;
    }
}

