/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.lib.net;

import okhttp3.Request;

public abstract class CacheStrategy<T> {
    private static final int STATUS_DEFAULT = -1;
    private static final int STATUS_TRUE = 1;
    private static final int STATUS_FALSE = 0;
    private CacheType cacheType = CacheType.READ_CACHE_ONLY_NOT_EXPIRES;
    private int readCacheStatus = -1;
    private int saveCacheStatus = -1;

    public CacheStrategy() {
        this(CacheType.READ_CACHE_ONLY_NOT_EXPIRES);
    }

    public CacheStrategy(CacheType cacheType) {
        this.cacheType = cacheType;
    }

    public CacheType getCacheType() {
        return this.cacheType;
    }

    public void setIsReadCache(boolean isReadCache) {
        this.readCacheStatus = isReadCache ? 1 : 0;
    }

    public boolean isReadCache() {
        if (this.readCacheStatus == -1) {
            return !this.cacheType.equals((Object)CacheType.NO_CACHE);
        }
        return this.readCacheStatus == 1;
    }

    public void setIsSaveCache(boolean isSaveCache) {
        this.saveCacheStatus = isSaveCache ? 1 : 0;
    }

    public boolean isSaveCache() {
        if (this.saveCacheStatus == -1) {
            return !this.cacheType.equals((Object)CacheType.NO_CACHE);
        }
        return this.saveCacheStatus == 1;
    }

    public void reset() {
        this.readCacheStatus = -1;
        this.saveCacheStatus = -1;
    }

    public abstract boolean isTimeOut();

    public abstract T readCache(Request var1);

    public abstract void saveCache(Request var1, T var2);

    public static enum CacheType {
        NO_CACHE,
        READ_CACHE_ONLY_NOT_EXPIRES,
        READ_CACHE_UPDATE_UI_THEN_NET_WHEN_EXPIRES,
        READ_CACHE_UPDATE_UI_THEN_NET;

    }
}

