/*
 * Decompiled with CFR 0.152.
 */
package com.levylin.loader.model.impl;

import com.levylin.loader.model.IListModel;
import com.levylin.loader.model.impl.Model;
import java.util.List;

public abstract class ListModel<INFO, ITEM>
extends Model<INFO>
implements IListModel<INFO, ITEM> {
    protected static int FIRST_PAGE = 0;
    protected static int PAGE_SIZE = 10;
    protected List<ITEM> mList;
    protected int page;
    private boolean hasNext;

    public ListModel(List<ITEM> itemList) {
        this.mList = itemList;
    }

    @Override
    public boolean isEmpty() {
        return this.mList == null || this.mList.isEmpty();
    }

    protected boolean ensureHasNext(INFO response, List<ITEM> mapList) {
        return mapList != null && mapList.size() == PAGE_SIZE;
    }

    @Override
    public void clear() {
        this.mList.clear();
    }

    @Override
    public void preLoadNext() {
        ++this.page;
    }

    @Override
    public void preRefresh() {
        this.page = FIRST_PAGE;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void setData(boolean isRefreshing, INFO response) {
        if (isRefreshing) {
            this.clear();
        }
        List mapList = this.map(response);
        this.hasNext = this.ensureHasNext(response, mapList);
        if (mapList == null) {
            return;
        }
        this.mList.addAll(mapList);
    }
}

