/*
 * Decompiled with CFR 0.152.
 */
package linc.com.amplituda;

import android.content.Context;
import android.content.res.Resources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import linc.com.amplituda.AmplitudaProgressListener;

final class FileManager {
    static final String AMPLITUDA_INTERNAL_TEMP = "amplituda_internal_temp";
    private final Resources resources;
    private final String cache;

    FileManager(Context context) {
        this.resources = context.getResources();
        this.cache = context.getCacheDir().getPath() + File.separator;
    }

    synchronized void deleteFile(File file) {
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    synchronized File getRawFile(int resource, AmplitudaProgressListener listener) {
        File temp = new File(this.cache, AMPLITUDA_INTERNAL_TEMP);
        try {
            InputStream inputStream = this.resources.openRawResource(resource);
            this.streamToFile(inputStream, temp, 4096, inputStream.available(), listener);
            return temp;
        }
        catch (Resources.NotFoundException | IOException ignored) {
            return null;
        }
    }

    synchronized File getUrlFile(String audioUrl, AmplitudaProgressListener listener) {
        File temp = new File(this.cache, AMPLITUDA_INTERNAL_TEMP);
        try {
            URL url = new URL(audioUrl);
            URLConnection connection = url.openConnection();
            connection.connect();
            this.streamToFile(new BufferedInputStream(url.openStream()), temp, 1024, this.getUrlContentLength(connection), listener);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return temp;
    }

    synchronized File getUriFile(InputStream audioStream, AmplitudaProgressListener listener) {
        File temp = new File(this.cache, AMPLITUDA_INTERNAL_TEMP);
        try {
            this.streamToFile(audioStream, temp, 4096, audioStream.available(), listener);
            return temp;
        }
        catch (Resources.NotFoundException | IOException ignored) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized File getByteArrayFile(byte[] audioByteArray, AmplitudaProgressListener listener) {
        File temp = new File(this.cache, AMPLITUDA_INTERNAL_TEMP);
        try (FileOutputStream outputStream = new FileOutputStream(temp);){
            listener.onProgressInternal(0);
            outputStream.write(audioByteArray);
            listener.onProgressInternal(100);
            File file = temp;
            return file;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamToFile(InputStream inputStream, File temp, int bufferSize, long contentLength, AmplitudaProgressListener listener) {
        try {
            int read;
            FileOutputStream fos = new FileOutputStream(temp);
            byte[] buffer = new byte[bufferSize];
            int bytesWritten = 0;
            int progress = 0;
            while ((read = inputStream.read(buffer)) != -1) {
                int current_progress;
                ((OutputStream)fos).write(buffer, 0, read);
                if (listener == null || contentLength <= 0L || (current_progress = (int)((double)((float)(bytesWritten += read) / (float)contentLength) * 100.0)) == progress) continue;
                listener.onProgressInternal(current_progress);
                progress = current_progress;
            }
            fos.flush();
            ((OutputStream)fos).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException | NullPointerException exception) {}
        }
    }

    private synchronized long getUrlContentLength(URLConnection url) {
        try {
            HttpURLConnection urlConnection = (HttpURLConnection)url;
            urlConnection.setRequestMethod("HEAD");
            String lengthHeaderField = urlConnection.getHeaderField("content-length");
            Long result = lengthHeaderField == null ? null : Long.valueOf(Long.parseLong(lengthHeaderField));
            return result == null || result < 0L ? -1L : result;
        }
        catch (Exception exception) {
            return -1L;
        }
    }
}

