/*
 * Decompiled with CFR 0.152.
 */
package linc.com.amplituda;

import java.util.LinkedHashSet;
import linc.com.amplituda.AmplitudaResult;
import linc.com.amplituda.AmplitudaResultJNI;
import linc.com.amplituda.InputAudio;
import linc.com.amplituda.callback.AmplitudaErrorListener;
import linc.com.amplituda.callback.AmplitudaSuccessListener;
import linc.com.amplituda.exceptions.AmplitudaException;

public final class AmplitudaProcessingOutput<T> {
    private final AmplitudaResult<T> amplitudaResult;
    private LinkedHashSet<AmplitudaException> processingErrors = new LinkedHashSet();

    private AmplitudaProcessingOutput(String amplitudes, InputAudio<T> inputAudio) {
        this.amplitudaResult = new AmplitudaResult<T>(amplitudes, inputAudio);
    }

    AmplitudaProcessingOutput(AmplitudaResultJNI processingData, InputAudio<T> inputAudio) {
        this(processingData.getAmplitudes(), inputAudio);
        this.processingErrors.addAll(processingData.getErrors());
    }

    AmplitudaProcessingOutput(AmplitudaException exception, InputAudio<T> inputAudio) {
        this("", inputAudio);
        this.processingErrors.add(exception);
    }

    public void get(AmplitudaSuccessListener<T> successListener, AmplitudaErrorListener errorListener) {
        this.handleAmplitudaProcessingErrors(errorListener);
        successListener.onSuccess(this.amplitudaResult);
    }

    public void get(AmplitudaSuccessListener<T> successListener) {
        this.get(successListener, null);
    }

    public AmplitudaResult<T> get(AmplitudaErrorListener errorListener) {
        this.handleAmplitudaProcessingErrors(errorListener);
        return this.amplitudaResult;
    }

    public AmplitudaResult<T> get() {
        return this.amplitudaResult;
    }

    private void handleAmplitudaProcessingErrors(AmplitudaErrorListener errorListener) {
        if (this.processingErrors.isEmpty()) {
            this.processingErrors = null;
            return;
        }
        for (AmplitudaException exception : this.processingErrors) {
            this.throwException(exception, errorListener);
        }
        this.processingErrors.clear();
        this.processingErrors = null;
    }

    private void throwException(AmplitudaException exception, AmplitudaErrorListener errorListener) {
        if (errorListener == null) {
            this.processingErrors.add(exception);
            return;
        }
        errorListener.onError(exception);
    }
}

