/*
 * Decompiled with CFR 0.152.
 */
package linc.com.amplituda;

import android.text.TextUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UnknownFormatFlagsException;

public class Amplituda {
    public static int SINGLE_LINE_SEQUENCE_FORMAT = 0;
    public static int NEW_LINE_SEQUENCE_FORMAT = 1;
    private String resultLog;

    public Amplituda fromFile(File audio) {
        this.fromPath(audio.getPath());
        return this;
    }

    public Amplituda fromPath(String audioPath) {
        this.resultLog = this.amplitudesFromAudioJNI(audioPath);
        return this;
    }

    public Amplituda amplitudesAsList(ListCallback listCallback) {
        String[] log = this.resultLog.split("\n");
        ArrayList<Integer> amplitudes = new ArrayList<Integer>();
        for (String amplitude : log) {
            amplitudes.add(Integer.valueOf(amplitude));
        }
        listCallback.onSuccess(amplitudes);
        return this;
    }

    public Amplituda amplitudesAsJson(StringCallback jsonCallback) {
        jsonCallback.onSuccess("[" + this.amplitudesToSingleLineSequence(this.resultLog, ", ") + "]");
        return this;
    }

    public Amplituda amplitudesAsSequence(int format, StringCallback stringCallback) {
        this.amplitudesAsSequence(format, " ", stringCallback);
        return this;
    }

    public Amplituda amplitudesAsSequence(int format, String singleLineDelimiter, StringCallback stringCallback) {
        switch (format) {
            case 0: {
                stringCallback.onSuccess(this.amplitudesToSingleLineSequence(this.resultLog, singleLineDelimiter));
                break;
            }
            case 1: {
                stringCallback.onSuccess(this.resultLog);
                break;
            }
            default: {
                throw new UnknownFormatFlagsException("Use SINGLE_LINE_SEQUENCE_FORMAT or NEW_LINE_SEQUENCE_FORMAT as a parameter when you call amplitudesAsSequence!");
            }
        }
        return this;
    }

    private String amplitudesToSingleLineSequence(String amplitudes, String delimiter) {
        Object[] log = amplitudes.split("\n");
        return TextUtils.join((CharSequence)delimiter, (Object[])log);
    }

    native String amplitudesFromAudioJNI(String var1);

    static {
        System.loadLibrary("native-lib");
    }

    public static interface StringCallback
    extends AmplitudaCallback<String> {
    }

    public static interface ListCallback
    extends AmplitudaCallback<List<Integer>> {
    }

    private static interface AmplitudaCallback<T> {
        public void onSuccess(T var1);
    }
}

