/*
 * Decompiled with CFR 0.152.
 */
package me.leefeng.promptlibrary;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import me.leefeng.promptlibrary.Builder;
import me.leefeng.promptlibrary.PromptButton;
import me.leefeng.promptlibrary.PromptDialog;

@SuppressLint(value={"AppCompatCustomView"})
class PromptView
extends ImageView {
    public static final int PROMPT_SUCCESS = 101;
    public static final int PROMPT_LOADING = 102;
    public static final int PROMPT_ERROR = 103;
    public static final int PROMPT_NONE = 104;
    public static final int PROMPT_INFO = 105;
    public static final int PROMPT_WARN = 106;
    public static final int PROMPT_ALERT_WARN = 107;
    private static final String TAG = "LOADVIEW";
    public static final int PROMPT_CUSTOM = 108;
    private PromptDialog promptDialog;
    private Builder builder;
    private int width;
    private int height;
    private ValueAnimator animator;
    private Paint paint;
    private float density;
    private Rect textRect;
    private int canvasWidth;
    private int canvasHeight;
    private RectF roundRect;
    private int currentType;
    private PromptButton[] buttons = new PromptButton[0];
    private RectF roundTouchRect;
    float buttonW;
    float buttonH;
    private Matrix max;

    public PromptView(Context context) {
        super(context);
    }

    public PromptView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PromptView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public PromptView(Activity context, Builder builder, PromptDialog promptDialog) {
        super((Context)context);
        this.builder = builder;
        this.promptDialog = promptDialog;
    }

    protected void onDraw(Canvas canvas) {
        if (this.canvasWidth == 0) {
            this.canvasWidth = this.getWidth();
            this.canvasHeight = this.getHeight();
        }
        this.paint.reset();
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.builder.backColor);
        this.paint.setAlpha(this.builder.backAlpha);
        canvas.drawRect(0.0f, 0.0f, (float)this.canvasWidth, (float)this.canvasHeight, this.paint);
        String text = this.builder.text;
        float pad = this.builder.padding * this.density;
        float round = this.builder.round * this.density;
        this.paint.reset();
        this.paint.setColor(this.builder.textColor);
        this.paint.setStrokeWidth(1.0f * this.density);
        this.paint.setTextSize(this.density * this.builder.textSize);
        this.paint.setAntiAlias(true);
        this.paint.getTextBounds(text, 0, text.length(), this.textRect);
        this.paint.getTextBounds(text, 0, text.length(), this.textRect);
        float popWidth = 0.0f;
        float popHeight = 0.0f;
        switch (this.currentType) {
            case 107: {
                popWidth = Math.max((float)this.textRect.width() + pad * 2.0f, 2.0f * this.buttonW);
                if (this.buttonW * 2.0f < (float)this.textRect.width() + pad * 2.0f) {
                    this.buttonW = ((float)this.textRect.width() + pad * 2.0f) / 2.0f;
                }
                popHeight = (float)this.textRect.height() + 3.0f * pad + (float)(this.height * 2) + this.buttonH;
                break;
            }
            default: {
                popWidth = Math.max(100.0f * this.density, (float)this.textRect.width() + pad * 2.0f);
                popHeight = (float)this.textRect.height() + 3.0f * pad + (float)(this.height * 2);
            }
        }
        float transTop = (float)(this.canvasHeight / 2) - popHeight / 2.0f;
        float transLeft = (float)(this.canvasWidth / 2) - popWidth / 2.0f;
        canvas.translate(transLeft, transTop);
        this.paint.reset();
        this.paint.setAntiAlias(true);
        this.paint.setColor(this.builder.roundColor);
        this.paint.setAlpha(this.builder.roundAlpha);
        if (this.roundTouchRect == null) {
            this.roundTouchRect = new RectF(transLeft, transTop, transLeft + popWidth, transTop + popHeight);
        }
        if (this.roundRect == null) {
            this.roundRect = new RectF(0.0f, 0.0f, popWidth, popHeight);
        }
        this.roundRect.set(0.0f, 0.0f, popWidth, popHeight);
        canvas.drawRoundRect(this.roundRect, round, round, this.paint);
        this.paint.reset();
        this.paint.setColor(this.builder.textColor);
        this.paint.setStrokeWidth(1.0f * this.density);
        this.paint.setTextSize(this.density * this.builder.textSize);
        this.paint.setAntiAlias(true);
        float top = pad * 2.0f + (float)(this.height * 2) + (float)this.textRect.height();
        float left = popWidth / 2.0f - (float)(this.textRect.width() / 2);
        canvas.drawText(text, left, top, this.paint);
        if (this.currentType == 107) {
            this.paint.setColor(-7829368);
            this.paint.setStrokeWidth(1.0f);
            this.paint.setAntiAlias(true);
            canvas.drawLine(0.0f, top += pad, popWidth, top, this.paint);
            if (this.buttons.length == 1) {
                PromptButton button = this.buttons[0];
                if (button.isFocus()) {
                    this.paint.reset();
                    this.paint.setAntiAlias(true);
                    this.paint.setColor(button.getFocusBacColor());
                    this.paint.setStyle(Paint.Style.FILL);
                    canvas.drawRect(0.0f, top, popWidth, top + this.buttonH - round, this.paint);
                    canvas.drawCircle(round, top + this.buttonH - round, round, this.paint);
                    canvas.drawCircle(popWidth - round, top + this.buttonH - round, round, this.paint);
                    canvas.drawRect(round, top + this.buttonH - round, popWidth - round, top + this.buttonH, this.paint);
                }
                String buttonText = button.getText();
                this.paint.reset();
                this.paint.setColor(button.getTextColor());
                this.paint.setStrokeWidth(1.0f * this.density);
                this.paint.setTextSize(this.density * button.getTextSize());
                this.paint.setAntiAlias(true);
                this.paint.getTextBounds(buttonText, 0, buttonText.length(), this.textRect);
                button.setTouchRect(new RectF(transLeft, transTop + top, transLeft + popWidth, transTop + top + this.buttonH));
                canvas.drawText(buttonText, popWidth / 2.0f - (float)(this.textRect.width() / 2), top + (float)(this.textRect.height() / 2) + this.buttonH / 2.0f, this.paint);
            }
            if (this.buttons.length > 1) {
                canvas.drawLine(popWidth / 2.0f, top, popWidth / 2.0f, popHeight, this.paint);
                for (int i = 0; i < this.buttons.length; ++i) {
                    PromptButton button = this.buttons[i];
                    if (button.isFocus()) {
                        this.paint.reset();
                        this.paint.setAntiAlias(true);
                        this.paint.setColor(button.getFocusBacColor());
                        this.paint.setStyle(Paint.Style.FILL);
                        canvas.drawRect(this.buttonW * (float)i, top + 1.0f, this.buttonW * (float)(i + 1), top + 1.0f + this.buttonH - round, this.paint);
                        if (i == 0) {
                            canvas.drawCircle(round, top + this.buttonH - round, round, this.paint);
                            canvas.drawRect(round, top + this.buttonH - round, this.buttonW * (float)(i + 1), top + this.buttonH, this.paint);
                        } else if (i == 1) {
                            canvas.drawCircle(this.buttonW * 2.0f - round, top + this.buttonH - round, round, this.paint);
                            canvas.drawRect(this.buttonW, top + this.buttonH - round, this.buttonW * 2.0f - round, top + this.buttonH, this.paint);
                        }
                    }
                    String buttonText = button.getText();
                    this.paint.reset();
                    this.paint.setColor(button.getTextColor());
                    this.paint.setStrokeWidth(1.0f * this.density);
                    this.paint.setTextSize(this.density * button.getTextSize());
                    this.paint.setAntiAlias(true);
                    this.paint.getTextBounds(buttonText, 0, buttonText.length(), this.textRect);
                    button.setTouchRect(new RectF(transLeft + (float)i * this.buttonW, transTop + top, transLeft + (float)i * this.buttonW + this.buttonW, transTop + top + this.buttonH));
                    canvas.drawText(buttonText, this.buttonW / 2.0f - (float)(this.textRect.width() / 2) + (float)i * this.buttonW, top + (float)(this.textRect.height() / 2) + this.buttonH / 2.0f, this.paint);
                }
            }
        }
        canvas.translate(popWidth / 2.0f - (float)this.width, pad);
        super.onDraw(canvas);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.paint = new Paint();
        this.initData();
    }

    private void initData() {
        this.textRect = new Rect();
        this.density = this.getResources().getDisplayMetrics().density;
        this.buttonW = this.density * 120.0f;
        this.buttonH = this.density * 44.0f;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.animator = null;
        this.textRect = null;
        this.roundTouchRect = null;
        this.promptDialog.onDetach();
    }

    private void start() {
        if (this.max == null || this.animator == null) {
            this.max = new Matrix();
            this.animator = ValueAnimator.ofInt((int[])new int[]{0, 12});
            this.animator.setDuration(960L);
            this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.animator.setRepeatCount(Integer.MAX_VALUE);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float degrees = 30 * (Integer)valueAnimator.getAnimatedValue();
                    PromptView.this.max.setRotate(degrees, (float)PromptView.this.width, (float)PromptView.this.height);
                    PromptView.this.setImageMatrix(PromptView.this.max);
                }
            });
        }
        if (!this.animator.isRunning()) {
            this.animator.start();
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (this.currentType == 107) {
            if (this.builder.cancleAble && event.getAction() == 0 && !this.roundTouchRect.contains(x, y)) {
                this.promptDialog.dismiss();
            }
            for (PromptButton button : this.buttons) {
                if (!button.getRect().contains(x, y)) continue;
                if (event.getAction() == 0) {
                    button.setFocus(true);
                    this.invalidate();
                }
                if (event.getAction() == 1) {
                    button.setFocus(false);
                    this.invalidate();
                    if (button.isDismissAfterClick()) {
                        this.promptDialog.dismiss();
                    }
                    if (button.getListener() != null) {
                        button.getListener().onClick(button);
                    }
                }
                return true;
            }
            if (event.getAction() == 1) {
                for (PromptButton button : this.buttons) {
                    button.setFocus(false);
                    this.invalidate();
                }
            }
        }
        return !this.builder.touchAble;
    }

    private void endAnimator() {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.end();
        }
    }

    public void showLoading() {
        this.setImageDrawable(this.getResources().getDrawable(this.builder.icon));
        this.width = this.getDrawable().getMinimumWidth() / 2;
        this.height = this.getDrawable().getMinimumHeight() / 2;
        this.start();
        this.currentType = 102;
    }

    Builder getBuilder() {
        return this.builder;
    }

    public void showSomthing(int currentType) {
        this.endAnimator();
        this.setImageDrawable(this.getResources().getDrawable(this.builder.icon));
        this.width = this.getDrawable().getMinimumWidth() / 2;
        this.height = this.getDrawable().getMinimumHeight() / 2;
        this.currentType = currentType;
        if (this.max != null) {
            this.max.setRotate(0.0f, (float)this.width, (float)this.height);
            this.setImageMatrix(this.max);
        }
        this.invalidate();
    }

    void showSomthingAlert(PromptButton ... button) {
        this.buttons = button;
        this.showSomthing(107);
    }

    public void setBuilder(Builder builder) {
        if (this.builder != builder) {
            this.builder = builder;
        }
    }

    public int getCurrentType() {
        return this.currentType;
    }
}

