/*
 * Decompiled with CFR 0.152.
 */
package com.llw.easyutil;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Toast;
import com.llw.easyutil.EasyView;
import com.llw.easyutil.R;

public final class EasyToast {
    private static Context mContext;
    private static Toast mToast;

    public static void init(Context context) {
        mContext = context;
        mToast = new Toast(mContext);
    }

    public static void show(CharSequence text) {
        Toast.makeText((Context)mContext, (CharSequence)text, (int)0).show();
    }

    public static void showLong(CharSequence text) {
        Toast.makeText((Context)mContext, (CharSequence)text, (int)1).show();
    }

    public static void showToast(Activity activity, String text) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setText(text);
        EasyToast.setToast(view);
    }

    public static void showLongToast(Activity activity, String text) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setText(text);
        EasyToast.setLongToast(view);
    }

    public static void showToast(Activity activity, String text, int gravity) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setText(text);
        EasyToast.setToast(view, gravity);
    }

    public static void showToast(Activity activity, String text, float radius) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setBgRadius(radius);
        easyView.setText(text);
        EasyToast.setToast(view);
    }

    public static void showColorToast(Activity activity, String text, int bgColor, int textColor) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setBgColor((Context)activity, bgColor);
        easyView.setTextColor((Context)activity, textColor);
        easyView.setText(text);
        EasyToast.setToast(view);
    }

    public static void showBgColorToast(Activity activity, String text, int bgColor) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setBgColor((Context)activity, bgColor);
        easyView.setText(text);
        EasyToast.setToast(view);
    }

    public static void showTxColorToast(Activity activity, String text, int textColor) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setTextColor((Context)activity, textColor);
        easyView.setText(text);
        EasyToast.setToast(view);
    }

    public static void showToastBase(Activity activity, String text, int bgColor, int textColor, float radius) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setBgColor((Context)activity, bgColor);
        easyView.setBgRadius(radius);
        easyView.setTextColor((Context)activity, textColor);
        easyView.setText(text);
        EasyToast.setToast(view);
    }

    public static void showToastPlus(Activity activity, String text, int gravity, int bgColor, int textColor, float radius) {
        LayoutInflater inflater = activity.getLayoutInflater();
        View view = inflater.inflate(R.layout.layout_easy_toast, null);
        EasyView easyView = (EasyView)view.findViewById(R.id.v_easy);
        easyView.setBgColor((Context)activity, bgColor);
        easyView.setBgRadius(radius);
        easyView.setTextColor((Context)activity, textColor);
        easyView.setText(text);
        EasyToast.setToast(view, gravity);
    }

    private static void setToast(View view) {
        mToast.setGravity(80, 12, 20);
        mToast.setDuration(0);
        mToast.setView(view);
        mToast.show();
    }

    private static void setToast(View view, int gravity) {
        mToast.setGravity(gravity == 0 ? 80 : (gravity == 1 ? 17 : 48), 12, 20);
        mToast.setDuration(0);
        mToast.setView(view);
        mToast.show();
    }

    private static void setLongToast(View view) {
        mToast.setGravity(80, 12, 20);
        mToast.setDuration(1);
        mToast.setView(view);
        mToast.show();
    }

    private static void setToast(View view, int gravity, boolean isLong) {
        mToast.setGravity(gravity == 0 ? 80 : (gravity == 1 ? 17 : 48), 12, 20);
        mToast.setDuration(isLong ? 1 : 0);
        mToast.setView(view);
        mToast.show();
    }
}

