/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.animation.Animator;
import android.animation.ArgbEvaluator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Checkable;
import com.lihang.R;

public class SwitchButton
extends View
implements Checkable {
    private static final int DEFAULT_WIDTH = SwitchButton.dp2pxInt(58.0f);
    private static final int DEFAULT_HEIGHT = SwitchButton.dp2pxInt(36.0f);
    private final int ANIMATE_STATE_NONE = 0;
    private final int ANIMATE_STATE_PENDING_DRAG = 1;
    private final int ANIMATE_STATE_DRAGING = 2;
    private final int ANIMATE_STATE_PENDING_RESET = 3;
    private final int ANIMATE_STATE_PENDING_SETTLE = 4;
    private final int ANIMATE_STATE_SWITCH = 5;
    private float viewRadius;
    private float buttonRadius;
    private float height;
    private float width;
    private float left;
    private float top;
    private float right;
    private float bottom;
    private float centerX;
    private float centerY;
    private int background;
    private int uncheckColor;
    private int checkedColor;
    private int borderWidth;
    private float buttonMinX;
    private float buttonMaxX;
    private Paint buttonPaint;
    private Paint paint;
    private ViewState viewState;
    private ViewState beforeState;
    private ViewState afterState;
    private RectF rect = new RectF();
    private int animateState = 0;
    private ValueAnimator valueAnimator;
    private final ArgbEvaluator argbEvaluator = new ArgbEvaluator();
    private boolean isChecked;
    private boolean enableEffect;
    private boolean isTouchingDown = false;
    private boolean isUiInited = false;
    private boolean isEventBroadcast = false;
    private OnCheckedChangeListener onCheckedChangeListener;
    private long touchDownTime;
    private Runnable postPendingDrag = new Runnable(){

        @Override
        public void run() {
            if (!SwitchButton.this.isInAnimating()) {
                SwitchButton.this.pendingDragState();
            }
        }
    };
    private int buttonColor;
    private int buttonCheckColor;
    private ValueAnimator.AnimatorUpdateListener animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            float value = ((Float)animation.getAnimatedValue()).floatValue();
            if (value == 1.0f && !SwitchButton.this.isChecked) {
                if (SwitchButton.this.buttonCheckColor != -101) {
                    SwitchButton.this.buttonPaint.setColor(SwitchButton.this.buttonCheckColor);
                }
            } else if (value == 0.0f && SwitchButton.this.isChecked) {
                SwitchButton.this.buttonPaint.setColor(SwitchButton.this.buttonColor);
            }
            switch (SwitchButton.this.animateState) {
                case 1: 
                case 3: 
                case 4: {
                    ((SwitchButton)SwitchButton.this).viewState.radius = ((SwitchButton)SwitchButton.this).beforeState.radius + (((SwitchButton)SwitchButton.this).afterState.radius - ((SwitchButton)SwitchButton.this).beforeState.radius) * value;
                    if (SwitchButton.this.animateState != 1) {
                        ((SwitchButton)SwitchButton.this).viewState.buttonX = ((SwitchButton)SwitchButton.this).beforeState.buttonX + (((SwitchButton)SwitchButton.this).afterState.buttonX - ((SwitchButton)SwitchButton.this).beforeState.buttonX) * value;
                    }
                    ((SwitchButton)SwitchButton.this).viewState.checkStateColor = (Integer)SwitchButton.this.argbEvaluator.evaluate(value, (Object)((SwitchButton)SwitchButton.this).beforeState.checkStateColor, (Object)((SwitchButton)SwitchButton.this).afterState.checkStateColor);
                    break;
                }
                case 5: {
                    ((SwitchButton)SwitchButton.this).viewState.buttonX = ((SwitchButton)SwitchButton.this).beforeState.buttonX + (((SwitchButton)SwitchButton.this).afterState.buttonX - ((SwitchButton)SwitchButton.this).beforeState.buttonX) * value;
                    float fraction = (((SwitchButton)SwitchButton.this).viewState.buttonX - SwitchButton.this.buttonMinX) / (SwitchButton.this.buttonMaxX - SwitchButton.this.buttonMinX);
                    ((SwitchButton)SwitchButton.this).viewState.checkStateColor = (Integer)SwitchButton.this.argbEvaluator.evaluate(fraction, (Object)SwitchButton.this.uncheckColor, (Object)SwitchButton.this.checkedColor);
                    ((SwitchButton)SwitchButton.this).viewState.radius = fraction * SwitchButton.this.viewRadius;
                    break;
                }
            }
            SwitchButton.this.postInvalidate();
        }
    };
    private Animator.AnimatorListener animatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            switch (SwitchButton.this.animateState) {
                case 2: {
                    break;
                }
                case 1: {
                    SwitchButton.this.animateState = 2;
                    ((SwitchButton)SwitchButton.this).viewState.radius = SwitchButton.this.viewRadius;
                    SwitchButton.this.postInvalidate();
                    break;
                }
                case 3: {
                    SwitchButton.this.animateState = 0;
                    SwitchButton.this.postInvalidate();
                    break;
                }
                case 4: {
                    SwitchButton.this.animateState = 0;
                    SwitchButton.this.postInvalidate();
                    SwitchButton.this.broadcastEvent();
                    break;
                }
                case 5: {
                    SwitchButton.this.isChecked = !SwitchButton.this.isChecked;
                    SwitchButton.this.animateState = 0;
                    SwitchButton.this.postInvalidate();
                    SwitchButton.this.broadcastEvent();
                    break;
                }
            }
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };

    public SwitchButton(Context context) {
        super(context);
        this.init(context, null);
    }

    public SwitchButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public SwitchButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public SwitchButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    public final void setPadding(int left, int top, int right, int bottom) {
        super.setPadding(0, 0, 0, 0);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = null;
        if (attrs != null) {
            typedArray = context.obtainStyledAttributes(attrs, R.styleable.SwitchButton);
        }
        this.uncheckColor = SwitchButton.optColor(typedArray, R.styleable.SwitchButton_hl_uncheck_color, -2236963);
        this.background = SwitchButton.optColor(typedArray, R.styleable.SwitchButton_hl_background, -101);
        if (this.background == -101) {
            this.background = this.uncheckColor;
        }
        this.checkedColor = SwitchButton.optColor(typedArray, R.styleable.SwitchButton_hl_checked_color, -12536321);
        this.borderWidth = SwitchButton.optPixelSize(typedArray, R.styleable.SwitchButton_hl_border_width, SwitchButton.dp2pxInt(2.0f));
        this.buttonColor = SwitchButton.optColor(typedArray, R.styleable.SwitchButton_hl_thumb_color, -1);
        this.buttonCheckColor = SwitchButton.optColor(typedArray, R.styleable.SwitchButton_hl_thumb_checked_color, -101);
        int effectDuration = SwitchButton.optInt(typedArray, R.styleable.SwitchButton_hl_duration, 300);
        this.isChecked = SwitchButton.optBoolean(typedArray, R.styleable.SwitchButton_hl_checked, false);
        this.enableEffect = SwitchButton.optBoolean(typedArray, R.styleable.SwitchButton_hl_enable_animal, true);
        if (typedArray != null) {
            typedArray.recycle();
        }
        this.paint = new Paint(1);
        this.buttonPaint = new Paint(1);
        this.buttonPaint.setColor(this.buttonColor);
        this.viewState = new ViewState();
        this.beforeState = new ViewState();
        this.afterState = new ViewState();
        this.valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.valueAnimator.setDuration((long)effectDuration);
        this.valueAnimator.setRepeatCount(0);
        this.valueAnimator.addUpdateListener(this.animatorUpdateListener);
        this.valueAnimator.addListener(this.animatorListener);
        super.setClickable(true);
        this.setPadding(0, 0, 0, 0);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (widthMode == 0 || widthMode == Integer.MIN_VALUE) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)DEFAULT_WIDTH, (int)0x40000000);
        }
        if (heightMode == 0 || heightMode == Integer.MIN_VALUE) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)DEFAULT_HEIGHT, (int)0x40000000);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float viewPadding = this.borderWidth;
        this.height = (float)h - viewPadding - viewPadding;
        this.width = (float)w - viewPadding - viewPadding;
        this.viewRadius = this.height * 0.5f;
        this.buttonRadius = this.viewRadius - (float)this.borderWidth;
        this.left = viewPadding;
        this.top = viewPadding;
        this.right = (float)w - viewPadding;
        this.bottom = (float)h - viewPadding;
        this.centerX = (this.left + this.right) * 0.5f;
        this.centerY = (this.top + this.bottom) * 0.5f;
        this.buttonMinX = this.left + this.viewRadius;
        this.buttonMaxX = this.right - this.viewRadius;
        if (this.isChecked()) {
            this.setCheckedViewState(this.viewState);
        } else {
            this.setUncheckViewState(this.viewState);
        }
        this.isUiInited = true;
        this.postInvalidate();
    }

    private void setUncheckViewState(ViewState viewState) {
        viewState.radius = 0.0f;
        viewState.checkStateColor = this.uncheckColor;
        viewState.buttonX = this.buttonMinX;
    }

    private void setCheckedViewState(ViewState viewState) {
        viewState.radius = this.viewRadius;
        viewState.checkStateColor = this.checkedColor;
        viewState.buttonX = this.buttonMaxX;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.paint.setStrokeWidth((float)this.borderWidth);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.background);
        this.drawRoundRect(canvas, this.left, this.top, this.right, this.bottom, this.viewRadius, this.paint);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.uncheckColor);
        this.drawRoundRect(canvas, this.left, this.top, this.right, this.bottom, this.viewRadius, this.paint);
        float des = this.viewState.radius * 0.5f;
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.viewState.checkStateColor);
        this.paint.setStrokeWidth((float)this.borderWidth + des * 2.0f);
        this.drawRoundRect(canvas, this.left + des, this.top + des, this.right - des, this.bottom - des, this.viewRadius, this.paint);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStrokeWidth(1.0f);
        this.drawArc(canvas, this.left, this.top, this.left + 2.0f * this.viewRadius, this.top + 2.0f * this.viewRadius, 90.0f, 180.0f, this.paint);
        canvas.drawRect(this.left + this.viewRadius, this.top, this.viewState.buttonX, this.top + 2.0f * this.viewRadius, this.paint);
        this.drawButton(canvas, this.viewState.buttonX, this.centerY);
    }

    private void drawArc(Canvas canvas, float left, float top, float right, float bottom, float startAngle, float sweepAngle, Paint paint) {
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawArc(left, top, right, bottom, startAngle, sweepAngle, true, paint);
        } else {
            this.rect.set(left, top, right, bottom);
            canvas.drawArc(this.rect, startAngle, sweepAngle, true, paint);
        }
    }

    private void drawRoundRect(Canvas canvas, float left, float top, float right, float bottom, float backgroundRadius, Paint paint) {
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawRoundRect(left, top, right, bottom, backgroundRadius, backgroundRadius, paint);
        } else {
            this.rect.set(left, top, right, bottom);
            canvas.drawRoundRect(this.rect, backgroundRadius, backgroundRadius, paint);
        }
    }

    private void drawButton(Canvas canvas, float x, float y) {
        canvas.drawCircle(x, y, this.buttonRadius, this.buttonPaint);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(1.0f);
        this.paint.setColor(-2236963);
        canvas.drawCircle(x, y, this.buttonRadius, this.paint);
    }

    public void setChecked(boolean checked) {
        if (checked == this.isChecked()) {
            this.postInvalidate();
            return;
        }
        this.toggleWithNoListener(false, true);
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean animate) {
        this.toggle(animate, true);
    }

    private void toggle(boolean animate, boolean broadcast) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isEventBroadcast) {
            throw new RuntimeException("should NOT switch the state in method: [onCheckedChanged]!");
        }
        if (!this.isUiInited) {
            boolean bl = this.isChecked = !this.isChecked;
            if (broadcast) {
                this.broadcastEvent();
            }
            return;
        }
        if (this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
        if (!this.enableEffect || !animate) {
            boolean bl = this.isChecked = !this.isChecked;
            if (this.isChecked()) {
                this.setCheckedViewState(this.viewState);
            } else {
                this.setUncheckViewState(this.viewState);
            }
            this.postInvalidate();
            if (broadcast) {
                this.broadcastEvent();
            }
            return;
        }
        this.animateState = 5;
        this.beforeState.copy(this.viewState);
        if (this.isChecked()) {
            this.setUncheckViewState(this.afterState);
        } else {
            this.setCheckedViewState(this.afterState);
        }
        this.valueAnimator.start();
    }

    private void toggleWithNoListener(boolean animate, boolean broadcast) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.isEventBroadcast) {
            throw new RuntimeException("should NOT switch the state in method: [onCheckedChanged]!");
        }
        if (!this.isUiInited) {
            this.isChecked = !this.isChecked;
            return;
        }
        if (this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
        if (!this.enableEffect || !animate) {
            boolean bl = this.isChecked = !this.isChecked;
            if (this.isChecked()) {
                this.setCheckedViewState(this.viewState);
            } else {
                this.setUncheckViewState(this.viewState);
            }
            this.postInvalidate();
            return;
        }
        this.animateState = 5;
        this.beforeState.copy(this.viewState);
        if (this.isChecked()) {
            this.setUncheckViewState(this.afterState);
        } else {
            this.setCheckedViewState(this.afterState);
        }
        this.valueAnimator.start();
    }

    private void broadcastEvent() {
        if (this.onCheckedChangeListener != null) {
            this.isEventBroadcast = true;
            this.onCheckedChangeListener.onCheckedChanged(this, this.isChecked());
        }
        this.isEventBroadcast = false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int actionMasked = event.getActionMasked();
        switch (actionMasked) {
            case 0: {
                this.isTouchingDown = true;
                this.touchDownTime = System.currentTimeMillis();
                this.removeCallbacks(this.postPendingDrag);
                this.postDelayed(this.postPendingDrag, 100L);
                break;
            }
            case 2: {
                float eventX = event.getX();
                if (this.isPendingDragState()) {
                    float fraction = eventX / (float)this.getWidth();
                    fraction = Math.max(0.0f, Math.min(1.0f, fraction));
                    this.viewState.buttonX = this.buttonMinX + (this.buttonMaxX - this.buttonMinX) * fraction;
                    break;
                }
                if (!this.isDragState()) break;
                float fraction = eventX / (float)this.getWidth();
                fraction = Math.max(0.0f, Math.min(1.0f, fraction));
                this.viewState.buttonX = this.buttonMinX + (this.buttonMaxX - this.buttonMinX) * fraction;
                this.viewState.checkStateColor = (Integer)this.argbEvaluator.evaluate(fraction, (Object)this.uncheckColor, (Object)this.checkedColor);
                this.postInvalidate();
                break;
            }
            case 1: {
                this.isTouchingDown = false;
                this.removeCallbacks(this.postPendingDrag);
                if (System.currentTimeMillis() - this.touchDownTime <= 300L) {
                    this.toggle();
                    break;
                }
                if (this.isDragState()) {
                    boolean newCheck;
                    float eventX = event.getX();
                    float fraction = eventX / (float)this.getWidth();
                    boolean bl = newCheck = (fraction = Math.max(0.0f, Math.min(1.0f, fraction))) > 0.5f;
                    if (newCheck == this.isChecked()) {
                        this.pendingCancelDragState();
                        break;
                    }
                    this.isChecked = newCheck;
                    this.pendingSettleState();
                    break;
                }
                if (!this.isPendingDragState()) break;
                this.pendingCancelDragState();
                break;
            }
            case 3: {
                this.isTouchingDown = false;
                this.removeCallbacks(this.postPendingDrag);
                if (!this.isPendingDragState() && !this.isDragState()) break;
                this.pendingCancelDragState();
            }
        }
        return true;
    }

    private boolean isInAnimating() {
        return this.animateState != 0;
    }

    private boolean isPendingDragState() {
        return this.animateState == 1 || this.animateState == 3;
    }

    private boolean isDragState() {
        return this.animateState == 2;
    }

    public void setEnableEffect(boolean enable) {
        this.enableEffect = enable;
    }

    private void pendingDragState() {
        if (this.isInAnimating()) {
            return;
        }
        if (!this.isTouchingDown) {
            return;
        }
        if (this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
        this.animateState = 1;
        this.beforeState.copy(this.viewState);
        this.afterState.copy(this.viewState);
        if (this.isChecked()) {
            this.afterState.checkStateColor = this.checkedColor;
            this.afterState.buttonX = this.buttonMaxX;
        } else {
            this.afterState.checkStateColor = this.uncheckColor;
            this.afterState.buttonX = this.buttonMinX;
            this.afterState.radius = this.viewRadius;
        }
        this.valueAnimator.start();
    }

    private void pendingCancelDragState() {
        if (this.isDragState() || this.isPendingDragState()) {
            if (this.valueAnimator.isRunning()) {
                this.valueAnimator.cancel();
            }
            this.animateState = 3;
            this.beforeState.copy(this.viewState);
            if (this.isChecked()) {
                this.setCheckedViewState(this.afterState);
            } else {
                this.setUncheckViewState(this.afterState);
            }
            this.valueAnimator.start();
        }
    }

    private void pendingSettleState() {
        if (this.valueAnimator.isRunning()) {
            this.valueAnimator.cancel();
        }
        this.animateState = 4;
        this.beforeState.copy(this.viewState);
        if (this.isChecked()) {
            this.setCheckedViewState(this.afterState);
        } else {
            this.setUncheckViewState(this.afterState);
        }
        this.valueAnimator.start();
    }

    public final void setOnClickListener(View.OnClickListener l) {
    }

    public final void setOnLongClickListener(View.OnLongClickListener l) {
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener l) {
        this.onCheckedChangeListener = l;
    }

    private static float dp2px(float dp) {
        Resources r = Resources.getSystem();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    private static int dp2pxInt(float dp) {
        return (int)SwitchButton.dp2px(dp);
    }

    private static int optInt(TypedArray typedArray, int index, int def) {
        if (typedArray == null) {
            return def;
        }
        return typedArray.getInt(index, def);
    }

    private static float optPixelSize(TypedArray typedArray, int index, float def) {
        if (typedArray == null) {
            return def;
        }
        return typedArray.getDimension(index, def);
    }

    private static int optPixelSize(TypedArray typedArray, int index, int def) {
        if (typedArray == null) {
            return def;
        }
        return typedArray.getDimensionPixelOffset(index, def);
    }

    private static int optColor(TypedArray typedArray, int index, int def) {
        if (typedArray == null) {
            return def;
        }
        return typedArray.getColor(index, def);
    }

    private static boolean optBoolean(TypedArray typedArray, int index, boolean def) {
        if (typedArray == null) {
            return def;
        }
        return typedArray.getBoolean(index, def);
    }

    private static class ViewState {
        float buttonX;
        int checkStateColor;
        float radius;

        ViewState() {
        }

        private void copy(ViewState source) {
            this.buttonX = source.buttonX;
            this.checkStateColor = source.checkStateColor;
            this.radius = source.radius;
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(SwitchButton var1, boolean var2);
    }
}

