/*
 * Decompiled with CFR 0.152.
 */
package com.lihang.help;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;

public class OkView
extends View {
    private Paint paint;
    private Paint okPaint;
    private int myRadius;
    private Path path = new Path();
    private PathMeasure pathMeasure;
    private ValueAnimator animator_draw_ok;
    private PathEffect effect;
    private boolean startDrawOk;

    public OkView(Context context) {
        this(context, null);
    }

    public OkView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OkView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL);
        this.okPaint = new Paint(1);
        this.okPaint.setStrokeWidth(5.0f);
        this.okPaint.setStyle(Paint.Style.STROKE);
        this.okPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)this.myRadius, this.paint);
        if (this.startDrawOk) {
            canvas.drawPath(this.path, this.okPaint);
        }
    }

    public void setOkColor(int color2) {
        this.okPaint.setColor(color2);
    }

    public void setCircleColor(int color2) {
        this.paint.setColor(color2);
    }

    public void setRadius(int radius) {
        this.myRadius = radius;
        int cHeight = radius * 2;
        this.path.moveTo((float)(cHeight / 8 * 3), (float)(cHeight / 2));
        this.path.lineTo((float)(cHeight / 2), (float)(cHeight / 5 * 3));
        this.path.lineTo((float)(cHeight / 3 * 2), (float)(cHeight / 5 * 2));
        this.pathMeasure = new PathMeasure(this.path, true);
        this.invalidate();
    }

    public void start(int duration) {
        this.animator_draw_ok = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.animator_draw_ok.setDuration((long)duration);
        this.animator_draw_ok.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                OkView.this.startDrawOk = true;
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                OkView.this.effect = (PathEffect)new DashPathEffect(new float[]{OkView.this.pathMeasure.getLength(), OkView.this.pathMeasure.getLength()}, value * OkView.this.pathMeasure.getLength());
                OkView.this.okPaint.setPathEffect(OkView.this.effect);
                OkView.this.invalidate();
            }
        });
        this.animator_draw_ok.start();
    }
}

