/*
 * Decompiled with CFR 0.152.
 */
package com.lihang;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import com.lihang.R;

public class ShadowLayout
extends FrameLayout {
    private int mShadowColor;
    private float mShadowLimit;
    private float mCornerRadius;
    private float mDx;
    private float mDy;
    private boolean leftShow;
    private boolean rightShow;
    private boolean topShow;
    private boolean bottomShow;
    private boolean mInvalidateShadowOnSizeChanged = true;
    private boolean mForceInvalidateShadow = false;

    public ShadowLayout(Context context) {
        super(context);
        this.initView(context, null);
    }

    public ShadowLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, attrs);
    }

    public ShadowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    protected int getSuggestedMinimumWidth() {
        return 0;
    }

    protected int getSuggestedMinimumHeight() {
        return 0;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0 && (this.getBackground() == null || this.mInvalidateShadowOnSizeChanged || this.mForceInvalidateShadow)) {
            this.mForceInvalidateShadow = false;
            this.setBackgroundCompat(w, h);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mForceInvalidateShadow) {
            this.mForceInvalidateShadow = false;
            this.setBackgroundCompat(right - left, bottom - top);
        }
    }

    public void setInvalidateShadowOnSizeChanged(boolean invalidateShadowOnSizeChanged) {
        this.mInvalidateShadowOnSizeChanged = invalidateShadowOnSizeChanged;
    }

    public void invalidateShadow() {
        this.mForceInvalidateShadow = true;
        this.requestLayout();
        this.invalidate();
    }

    private void initView(Context context, AttributeSet attrs) {
        this.initAttributes(context, attrs);
        int xPadding = (int)(this.mShadowLimit + Math.abs(this.mDx));
        int yPadding = (int)(this.mShadowLimit + Math.abs(this.mDy));
        int left = this.leftShow ? xPadding : 0;
        int top = this.topShow ? yPadding : 0;
        int right = this.rightShow ? xPadding : 0;
        int bottom = this.bottomShow ? yPadding : 0;
        this.setPadding(left, top, right, bottom);
    }

    private void setBackgroundCompat(int w, int h) {
        Bitmap bitmap = this.createShadowBitmap(w, h, this.mCornerRadius, this.mShadowLimit, this.mDx, this.mDy, this.mShadowColor, 0);
        BitmapDrawable drawable = new BitmapDrawable(this.getResources(), bitmap);
        if (Build.VERSION.SDK_INT <= 16) {
            this.setBackgroundDrawable((Drawable)drawable);
        } else {
            this.setBackground((Drawable)drawable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Context context, AttributeSet attrs) {
        TypedArray attr = this.getTypedArray(context, attrs, R.styleable.ShadowLayout);
        if (attr == null) {
            return;
        }
        try {
            this.leftShow = attr.getBoolean(R.styleable.ShadowLayout_hl_leftShow, true);
            this.rightShow = attr.getBoolean(R.styleable.ShadowLayout_hl_rightShow, true);
            this.bottomShow = attr.getBoolean(R.styleable.ShadowLayout_hl_bottomShow, true);
            this.topShow = attr.getBoolean(R.styleable.ShadowLayout_hl_topShow, true);
            this.mCornerRadius = attr.getDimension(R.styleable.ShadowLayout_hl_cornerRadius, this.getResources().getDimension(R.dimen.dp_5));
            this.mShadowLimit = attr.getDimension(R.styleable.ShadowLayout_hl_shadowLimit, this.getResources().getDimension(R.dimen.dp_5));
            this.mDx = attr.getDimension(R.styleable.ShadowLayout_hl_dx, 0.0f);
            this.mDy = attr.getDimension(R.styleable.ShadowLayout_hl_dy, 0.0f);
            this.mShadowColor = attr.getColor(R.styleable.ShadowLayout_hl_shadowColor, this.getResources().getColor(R.color.default_shadow_color));
        }
        finally {
            attr.recycle();
        }
    }

    private TypedArray getTypedArray(Context context, AttributeSet attributeSet, int[] attr) {
        return context.obtainStyledAttributes(attributeSet, attr, 0, 0);
    }

    private Bitmap createShadowBitmap(int shadowWidth, int shadowHeight, float cornerRadius, float shadowRadius, float dx, float dy, int shadowColor, int fillColor) {
        Bitmap output = Bitmap.createBitmap((int)shadowWidth, (int)shadowHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        RectF shadowRect = new RectF(shadowRadius, shadowRadius, (float)shadowWidth - shadowRadius, (float)shadowHeight - shadowRadius);
        if (dy > 0.0f) {
            shadowRect.top += dy;
            shadowRect.bottom -= dy;
        } else if (dy < 0.0f) {
            shadowRect.top += Math.abs(dy);
            shadowRect.bottom -= Math.abs(dy);
        }
        if (dx > 0.0f) {
            shadowRect.left += dx;
            shadowRect.right -= dx;
        } else if (dx < 0.0f) {
            shadowRect.left += Math.abs(dx);
            shadowRect.right -= Math.abs(dx);
        }
        Paint shadowPaint = new Paint();
        shadowPaint.setAntiAlias(true);
        shadowPaint.setColor(fillColor);
        shadowPaint.setStyle(Paint.Style.FILL);
        if (!this.isInEditMode()) {
            shadowPaint.setShadowLayer(shadowRadius, dx, dy, shadowColor);
        }
        canvas.drawRoundRect(shadowRect, cornerRadius, cornerRadius, shadowPaint);
        return output;
    }
}

