/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox;

import com.lowagie.text.Document;
import com.lowagie.toolbox.AbstractTool;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class Versions
extends JFrame {
    private static final long serialVersionUID = 2925242862240301106L;
    JLabel library_versions = new JLabel();
    JTable plugin_versions = new JTable();
    JScrollPane scroll_versions = new JScrollPane();

    public Versions() {
        super("Plugins and their version");
        try {
            this.initialize();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Versions version = new Versions();
        version.setDefaultCloseOperation(3);
        version.setVisible(true);
    }

    private void initialize() throws Exception {
        this.getContentPane().setLayout(new BorderLayout());
        this.scroll_versions.setViewportView(this.plugin_versions);
        this.library_versions.setIcon(new ImageIcon(Versions.class.getResource("1t3xt.gif")));
        this.getContentPane().add((Component)this.library_versions, "North");
        this.getContentPane().add((Component)this.scroll_versions, "Center");
        Properties properties = System.getProperties();
        Runtime runtime = Runtime.getRuntime();
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append("<p>iTexttoolbox version: ").append(Versions.class.getPackage().getImplementationVersion()).append("</p>");
        sb.append("<p>iText version: ").append(Document.getVersion()).append("</p>");
        sb.append("<p>java.version: ").append(properties.getProperty("java.version")).append("</p>");
        sb.append("<p>java.vendor: ").append(properties.getProperty("java.vendor")).append("</p>");
        sb.append("<p>java.home: ").append(properties.getProperty("java.home")).append("</p>");
        sb.append("<p>java.freeMemory: ").append(runtime.freeMemory()).append(" bytes").append("</p>");
        sb.append("<p>java.totalMemory: ").append(runtime.totalMemory()).append(" bytes").append("</p>");
        sb.append("<p>user.home: ").append(properties.getProperty("user.home")).append("</p>");
        sb.append("<p>os.name: ").append(properties.getProperty("os.name")).append("</p>");
        sb.append("<p>os.arch: ").append(properties.getProperty("os.arch")).append("</p>");
        sb.append("<p>os.version: ").append(properties.getProperty("os.version")).append("</p>");
        sb.append("</html>");
        this.library_versions.setText(sb.toString());
        TableModel model = this.getVersionTableModel(AbstractTool.versionsarray);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(model);
        this.plugin_versions.setRowSorter(sorter);
        this.plugin_versions.setModel(model);
        this.pack();
    }

    public TableModel getVersionTableModel(final ArrayList<String> versionsarray) {
        return new AbstractTableModel(){
            private static final long serialVersionUID = 5105003782164682777L;

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public int getRowCount() {
                return versionsarray.size();
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                switch (columnIndex) {
                    case 0: {
                        String dummy = (String)versionsarray.get(rowIndex);
                        return dummy.split(".java")[0];
                    }
                    case 1: {
                        String dummy = (String)versionsarray.get(rowIndex);
                        return dummy.split(" ")[1];
                    }
                    case 2: {
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        String dummy = (String)versionsarray.get(rowIndex);
                        try {
                            return df.parse(dummy.split(" ")[2] + " " + dummy.split(" ")[3]);
                        }
                        catch (ParseException ex) {
                            return null;
                        }
                    }
                    case 3: {
                        String dummy = (String)versionsarray.get(rowIndex);
                        return dummy.split(" ")[4];
                    }
                }
                return versionsarray;
            }

            @Override
            public String getColumnName(int column) {
                switch (column) {
                    case 0: {
                        return "Name";
                    }
                    case 1: {
                        return "Version";
                    }
                    case 2: {
                        return "Changed";
                    }
                    case 3: {
                        return "ChangeBy";
                    }
                }
                return "";
            }

            public Class<? extends Object> getColumnClass(int column) {
                switch (column) {
                    case 0: {
                        return String.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Date.class;
                    }
                    case 3: {
                        return String.class;
                    }
                }
                return null;
            }
        };
    }
}

