/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.plugins;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import com.lowagie.toolbox.arguments.FileArgument;
import com.lowagie.toolbox.arguments.StringArgument;
import com.lowagie.toolbox.arguments.filters.PdfFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Decrypt
extends AbstractTool {
    public Decrypt() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to decrypt", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the decrypted PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new StringArgument(this, "ownerpassword", "The ownerpassword you want to add to the PDF file"));
    }

    public static void main(String[] args) {
        Decrypt tool = new Decrypt();
        if (args.length < 2) {
            System.err.println(tool.getUsage());
        }
        tool.setMainArguments(args);
        tool.execute();
    }

    @Override
    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Decrypt", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Decrypt OPENED ===");
    }

    @Override
    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            byte[] ownerpassword = null;
            if (this.getValue("ownerpassword") != null) {
                ownerpassword = ((String)this.getValue("ownerpassword")).getBytes();
            }
            PdfReader reader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath(), ownerpassword);
            PdfStamper stamper = new PdfStamper(reader, (OutputStream)new FileOutputStream((File)this.getValue("destfile")));
            stamper.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.internalFrame, e.getMessage(), e.getClass().getName(), 0);
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void valueHasChanged(AbstractArgument arg) {
        if (this.internalFrame == null) {
            return;
        }
    }

    @Override
    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Decrypt.addVersion("$Id: Decrypt.java 3271 2008-04-18 20:39:42Z xlv $");
    }
}

