/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.toolbox.arguments;

import com.lowagie.toolbox.AbstractTool;
import com.lowagie.toolbox.arguments.AbstractArgument;
import java.awt.event.ActionEvent;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class BitsetArgument
extends AbstractArgument {
    private JCheckBox[] options;

    public BitsetArgument(AbstractTool tool, String name, String description, String[] options) {
        super(tool, name, description, null);
        this.options = new JCheckBox[options.length];
        for (int i = 0; i < options.length; ++i) {
            this.options[i] = new JCheckBox(options[i]);
        }
    }

    @Override
    public String getUsage() {
        StringBuilder buf = new StringBuilder(super.getUsage());
        buf.append("    possible options:\n");
        for (JCheckBox option : this.options) {
            buf.append("    - ");
            buf.append(option.getText());
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object[] message = new Object[1 + this.options.length];
        message[0] = "Check the options you need:";
        System.arraycopy(this.options, 0, message, 1, this.options.length);
        int result = JOptionPane.showOptionDialog(this.tool.getInternalFrame(), message, this.description, 2, 3, null, null, null);
        if (result == 0) {
            StringBuilder buf = new StringBuilder();
            for (JCheckBox option : this.options) {
                if (option.isSelected()) {
                    buf.append('1');
                    continue;
                }
                buf.append('0');
            }
            this.setValue(buf.toString());
        }
    }
}

